/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.checks.utils.BackboneCheckUtils;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.CallExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ObjectLiteralTree;
import org.sonar.javascript.model.interfaces.expression.PairPropertyTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S2550", name="\"defaults\" should be a function when objects or arrays are used", priority=Priority.CRITICAL, tags={"backbone", "bug"})
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ModelDefaultsWithArrayOrObjectCheck
extends BaseTreeVisitor {
    public void visitCallExpression(CallExpressionTree tree) {
        PairPropertyTree defaultsProp;
        Tree parameter;
        if (BackboneCheckUtils.isModelCreation(tree) && !tree.arguments().parameters().isEmpty() && (parameter = (Tree)tree.arguments().parameters().get(0)).is(new Tree.Kind[]{Tree.Kind.OBJECT_LITERAL}) && (defaultsProp = BackboneCheckUtils.getModelProperty((ObjectLiteralTree)parameter, "defaults")) != null && defaultsProp.value().is(new Tree.Kind[]{Tree.Kind.OBJECT_LITERAL}) && this.hasObjectOrArrayAttribute((ObjectLiteralTree)defaultsProp.value())) {
            this.getContext().addIssue((CodeVisitor)this, (Tree)defaultsProp, "Make \"defaults\" a function.");
        }
        super.visitCallExpression(tree);
    }

    private boolean hasObjectOrArrayAttribute(ObjectLiteralTree objectLiteral) {
        for (Tree property : objectLiteral.properties()) {
            if (!property.is(new Tree.Kind[]{Tree.Kind.PAIR_PROPERTY}) || !((PairPropertyTree)property).value().is(new Tree.Kind[]{Tree.Kind.ARRAY_LITERAL, Tree.Kind.OBJECT_LITERAL})) continue;
            return true;
        }
        return false;
    }
}

