/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.BinaryExpressionTree;
import org.sonar.javascript.model.interfaces.expression.NewExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ParenthesisedExpressionTree;
import org.sonar.javascript.model.interfaces.expression.UnaryExpressionTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="Parentheses", name="Useless parentheses around expressions should be removed to prevent any misunderstanding", priority=Priority.MAJOR, tags={"confusing"})
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class ParenthesesCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.DELETE, Tree.Kind.TYPEOF, Tree.Kind.VOID, EcmaScriptKeyword.RETURN, EcmaScriptKeyword.THROW, Tree.Kind.NEW_EXPRESSION, EcmaScriptKeyword.IN});
    }

    public void visitNode(AstNode node) {
        if (node.is(new AstNodeType[]{Tree.Kind.DELETE, Tree.Kind.TYPEOF, Tree.Kind.VOID})) {
            UnaryExpressionTree prefixExpr = (UnaryExpressionTree)node;
            if (prefixExpr.expression().is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION})) {
                this.reportIssue(node);
            }
        } else if (node.is(new AstNodeType[]{Tree.Kind.NEW_EXPRESSION})) {
            NewExpressionTree tree = (NewExpressionTree)node;
            if (tree.arguments() == null && tree.expression().is(new Tree.Kind[]{Tree.Kind.PARENTHESISED_EXPRESSION}) && !(((ParenthesisedExpressionTree)tree.expression()).expression() instanceof BinaryExpressionTree)) {
                this.reportIssue(node);
            }
        } else if (this.isNotRelationalInExpression(node) && node.getNextAstNode().is(new AstNodeType[]{Tree.Kind.PARENTHESISED_EXPRESSION})) {
            this.reportIssue(node);
        }
    }

    private boolean isNotRelationalInExpression(AstNode node) {
        return !node.is(new AstNodeType[]{EcmaScriptKeyword.IN}) || !node.getParent().is(new AstNodeType[]{Tree.Kind.RELATIONAL_IN});
    }

    private void reportIssue(AstNode node) {
        this.getContext().createLineViolation((CodeCheck)this, "Those parentheses are useless.", node, new Object[0]);
    }
}

