/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.CallExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S2427", name="The base should be provided to \"parseInt\"", priority=Priority.CRITICAL, tags={"bug"})
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class ParseIntCallWithoutBaseCheck
extends BaseTreeVisitor {
    public void visitCallExpression(CallExpressionTree tree) {
        if (this.isParseIntCall(tree.callee()) && tree.arguments().parameters().size() == 1) {
            this.getContext().addIssue((CodeVisitor)this, (Tree)tree, "Add the base to this \"parseInt\" call.");
        }
        super.visitCallExpression(tree);
    }

    private boolean isParseIntCall(ExpressionTree callee) {
        return callee.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && "parseInt".equals(((IdentifierTree)callee).name());
    }
}

