/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Objects;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Stack;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.statement.LabelledStatementTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="TooManyBreakOrContinueInLoop", name="Loops should not contain more than a single \"break\" or \"continue\" statement", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="20min")
public class TooManyBreakOrContinueInLoopCheck
extends SquidCheck<LexerlessGrammar> {
    private Stack<JumpTarget> jumpTargets;
    private static final GrammarRuleKey[] FUNCTION_NODES = new GrammarRuleKey[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION};

    public void init() {
        this.subscribeTo((AstNodeType[])CheckUtils.iterationStatementsArray());
        this.subscribeTo(new AstNodeType[]{Tree.Kind.BREAK_STATEMENT, Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.SWITCH_STATEMENT, Tree.Kind.LABELLED_STATEMENT});
        this.subscribeTo((AstNodeType[])FUNCTION_NODES);
    }

    public void visitFile(AstNode astNode) {
        this.jumpTargets = new Stack();
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{Tree.Kind.LABELLED_STATEMENT})) {
            String label = ((LabelledStatementTree)astNode).label().name();
            this.jumpTargets.push(new JumpTarget(label));
        } else if (astNode.is(new AstNodeType[]{Tree.Kind.BREAK_STATEMENT, Tree.Kind.CONTINUE_STATEMENT})) {
            AstNode labelNode = astNode.getFirstChild(new AstNodeType[]{Tree.Kind.LABEL_IDENTIFIER});
            String label = labelNode == null ? null : labelNode.getTokenValue();
            for (int i = this.jumpTargets.size() - 1; i >= 0; --i) {
                JumpTarget jumpTarget = (JumpTarget)this.jumpTargets.get(i);
                jumpTarget.jumps++;
                if (!Objects.equal((Object)label, (Object)jumpTarget.label)) {
                    continue;
                }
                break;
            }
        } else {
            this.jumpTargets.push(new JumpTarget());
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.isNot(new AstNodeType[]{Tree.Kind.BREAK_STATEMENT, Tree.Kind.CONTINUE_STATEMENT})) {
            JumpTarget jumpTarget = this.jumpTargets.pop();
            if (CheckUtils.isIterationStatement(astNode) && jumpTarget.jumps > 1) {
                this.getContext().createLineViolation((CodeCheck)this, "Reduce the total number of \"break\" and \"continue\" statements in this loop to use one at most.", astNode, new Object[0]);
            }
        }
    }

    public void leaveFile(AstNode astNode) {
        this.jumpTargets = null;
    }

    private static class JumpTarget {
        private final String label;
        private int jumps;

        public JumpTarget() {
            this.label = null;
        }

        public JumpTarget(String label) {
            this.label = label;
        }
    }
}

