/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S104", name="Files should not have too many lines", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1h")
public class TooManyLinesInFileCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT = 1000;
    @RuleProperty(key="maximum", description="Maximum authorized lines in a file.", defaultValue="1000")
    public int maximum = 1000;

    public void init() {
        this.subscribeTo(new AstNodeType[]{GenericTokenType.EOF});
    }

    public void visitNode(AstNode astNode) {
        int lines = astNode.getTokenLine();
        if (lines > this.maximum) {
            this.getContext().createFileViolation((CodeCheck)this, "File \"{0}\" has {1} lines, which is greater than {2} authorized. Split it into smaller files.", new Object[]{this.getContext().getFile().getName(), lines, this.maximum});
        }
    }
}

