/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="TrailingComma", name="Trailing commas should not be used", priority=Priority.BLOCKER, tags={"cross-browser"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="1min")
public class TrailingCommaCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.ARRAY_LITERAL, Tree.Kind.OBJECT_LITERAL});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.getLastChild().getPreviousSibling().getType() == EcmaScriptPunctuator.COMMA) {
            this.getContext().createLineViolation((CodeCheck)this, "Avoid trailing comma in array and object literals.", astNode, new Object[0]);
        }
    }
}

