/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.model.implementations.declaration.ParameterListTreeImpl;
import org.sonar.javascript.model.implementations.statement.VariableDeclarationTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ArrowFunctionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="VariableDeclarationAfterUsage", name="Variables should be declared before they are used", priority=Priority.MAJOR, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class VariableDeclarationAfterUsageCheck
extends SquidCheck<LexerlessGrammar> {
    private static final GrammarRuleKey[] FUNCTION_NODES = new GrammarRuleKey[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.METHOD, Tree.Kind.GENERATOR_METHOD, Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.ARROW_FUNCTION};
    private static final GrammarRuleKey[] CONST_AND_VAR_NODES = new GrammarRuleKey[]{Tree.Kind.VAR_DECLARATION, Tree.Kind.LET_DECLARATION, Tree.Kind.CONST_DECLARATION};
    private Scope currentScope;

    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.IDENTIFIER_REFERENCE, Tree.Kind.FORMAL_PARAMETER_LIST, Tree.Kind.ARROW_FUNCTION});
        this.subscribeTo((AstNodeType[])CONST_AND_VAR_NODES);
        this.subscribeTo((AstNodeType[])FUNCTION_NODES);
    }

    public void visitFile(AstNode astNode) {
        this.currentScope = new Scope();
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is((AstNodeType[])FUNCTION_NODES)) {
            this.currentScope = new Scope(this.currentScope);
        } else if (astNode.is(new AstNodeType[]{Tree.Kind.FORMAL_PARAMETER_LIST})) {
            this.declareInCurrentScope(((ParameterListTreeImpl)astNode).parameterIdentifiers());
        } else if (astNode.is(new AstNodeType[]{Tree.Kind.ARROW_FUNCTION})) {
            Tree parameter = ((ArrowFunctionTree)astNode).parameters();
            if (parameter.is(new Tree.Kind[]{Tree.Kind.BINDING_IDENTIFIER})) {
                this.declareInCurrentScope((List<IdentifierTree>)ImmutableList.of((Object)((IdentifierTree)parameter)));
            }
        } else if (astNode.is((AstNodeType[])CONST_AND_VAR_NODES)) {
            this.declareInCurrentScope(((VariableDeclarationTreeImpl)astNode).variableIdentifiers());
        } else if (astNode.is(new AstNodeType[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            if (astNode.getParent().is(new AstNodeType[]{Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT}) && astNode.getNextAstNode().is(new AstNodeType[]{EcmaScriptKeyword.IN, EcmaScriptGrammar.OF})) {
                this.declareInCurrentScope((List<IdentifierTree>)ImmutableList.of((Object)((IdentifierTree)astNode)));
            } else {
                this.currentScope.use(astNode);
            }
        }
    }

    private void declareInCurrentScope(List<IdentifierTree> identifiers) {
        for (IdentifierTree identifier : identifiers) {
            this.currentScope.declare(identifier);
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is((AstNodeType[])FUNCTION_NODES)) {
            this.checkCurrentScope();
            for (Map.Entry<String, AstNode> entry : this.currentScope.firstUsage.entrySet()) {
                if (this.currentScope.firstDeclaration.containsKey(entry.getKey())) continue;
                this.currentScope.outerScope.use(entry.getValue());
            }
            this.currentScope = this.currentScope.outerScope;
        }
    }

    private void checkCurrentScope() {
        for (Map.Entry<String, AstNode> entry : this.currentScope.firstDeclaration.entrySet()) {
            AstNode declaration = entry.getValue();
            AstNode usage = this.currentScope.firstUsage.get(entry.getKey());
            if (usage == null || usage.getTokenLine() >= declaration.getTokenLine()) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Variable '" + entry.getKey() + "' referenced before declaration.", usage, new Object[0]);
        }
    }

    public void leaveFile(AstNode astNode) {
        this.checkCurrentScope();
        this.currentScope = null;
    }

    private static class Scope {
        private final Scope outerScope;
        Map<String, AstNode> firstDeclaration = Maps.newHashMap();
        Map<String, AstNode> firstUsage = Maps.newHashMap();

        public Scope() {
            this.outerScope = null;
        }

        public Scope(Scope outerScope) {
            this.outerScope = outerScope;
        }

        private void declare(IdentifierTree identifierTree) {
            String identifier = identifierTree.name();
            if (!this.firstDeclaration.containsKey(identifier)) {
                this.firstDeclaration.put(identifier, (AstNode)identifierTree);
            }
        }

        private void use(AstNode astNode) {
            String identifier = astNode.getTokenValue();
            if (!this.firstUsage.containsKey(identifier)) {
                this.firstUsage.put(identifier, astNode);
            }
        }
    }
}

