/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.utils;

import javax.annotation.Nullable;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.CallExpressionTree;
import org.sonar.javascript.model.interfaces.expression.DotMemberExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.javascript.model.interfaces.expression.ObjectLiteralTree;
import org.sonar.javascript.model.interfaces.expression.PairPropertyTree;

public class BackboneCheckUtils {
    private BackboneCheckUtils() {
    }

    public static boolean isModelCreation(CallExpressionTree callExpression) {
        DotMemberExpressionTree memberExpr;
        if (callExpression.callee().is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION}) && BackboneCheckUtils.isExpressionIdentifierNamed((memberExpr = (DotMemberExpressionTree)callExpression.callee()).property(), "extend") && memberExpr.object().is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            return BackboneCheckUtils.isExpressionIdentifierNamed((memberExpr = (DotMemberExpressionTree)memberExpr.object()).object(), "Backbone") && BackboneCheckUtils.isExpressionIdentifierNamed(memberExpr.property(), "Model");
        }
        return false;
    }

    @Nullable
    public static PairPropertyTree getModelProperty(ObjectLiteralTree objectLiteral, String propertyName) {
        for (Tree property : objectLiteral.properties()) {
            PairPropertyTree pairProperty;
            if (!property.is(new Tree.Kind[]{Tree.Kind.PAIR_PROPERTY}) || !BackboneCheckUtils.isExpressionIdentifierNamed((pairProperty = (PairPropertyTree)property).key(), propertyName)) continue;
            return pairProperty;
        }
        return null;
    }

    private static boolean isExpressionIdentifierNamed(ExpressionTree tree, String name) {
        return tree instanceof IdentifierTree && name.equals(((IdentifierTree)tree).name());
    }
}

