/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.utils;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.List;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.interfaces.Tree;

public class CheckUtils {
    public static final ImmutableSet<Tree.Kind> ASSIGNMENT_EXPRESSION = ImmutableSet.of((Object)Tree.Kind.ASSIGNMENT, (Object)Tree.Kind.MULTIPLY_ASSIGNMENT, (Object)Tree.Kind.DIVIDE_ASSIGNMENT, (Object)Tree.Kind.REMAINDER_ASSIGNMENT, (Object)Tree.Kind.PLUS_ASSIGNMENT, (Object)Tree.Kind.MINUS_ASSIGNMENT, (Object[])new Tree.Kind[]{Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT});
    public static final ImmutableSet<Tree.Kind> RELATIONAL_EXPRESSION = ImmutableSet.of((Object)Tree.Kind.LESS_THAN, (Object)Tree.Kind.GREATER_THAN, (Object)Tree.Kind.LESS_THAN_OR_EQUAL_TO, (Object)Tree.Kind.GREATER_THAN_OR_EQUAL_TO, (Object)Tree.Kind.INSTANCE_OF, (Object)Tree.Kind.RELATIONAL_IN, (Object[])new Tree.Kind[0]);
    public static final ImmutableSet<Tree.Kind> POSTFIX_EXPRESSION = ImmutableSet.of((Object)Tree.Kind.POSTFIX_INCREMENT, (Object)Tree.Kind.POSTFIX_DECREMENT);
    public static final ImmutableSet<Tree.Kind> PREFIX_EXPRESSION = ImmutableSet.of((Object)Tree.Kind.DELETE, (Object)Tree.Kind.VOID, (Object)Tree.Kind.TYPEOF, (Object)Tree.Kind.PREFIX_INCREMENT, (Object)Tree.Kind.PREFIX_DECREMENT, (Object)Tree.Kind.UNARY_PLUS, (Object[])new Tree.Kind[]{Tree.Kind.UNARY_MINUS, Tree.Kind.BITWISE_COMPLEMENT, Tree.Kind.LOGICAL_COMPLEMENT});
    public static final ImmutableSet<Tree.Kind> EQUALITY_EXPRESSION = ImmutableSet.of((Object)Tree.Kind.EQUAL_TO, (Object)Tree.Kind.NOT_EQUAL_TO, (Object)Tree.Kind.STRICT_EQUAL_TO, (Object)Tree.Kind.STRICT_NOT_EQUAL_TO);
    public static final ImmutableSet<Tree.Kind> ITERATION_STATEMENTS = ImmutableSet.of((Object)Tree.Kind.DO_WHILE_STATEMENT, (Object)Tree.Kind.WHILE_STATEMENT, (Object)Tree.Kind.FOR_IN_STATEMENT, (Object)Tree.Kind.FOR_OF_STATEMENT, (Object)Tree.Kind.FOR_STATEMENT);
    public static final ImmutableSet<Tree.Kind> FUNCTION_NODES = ImmutableSet.of((Object)Tree.Kind.FUNCTION_EXPRESSION, (Object)Tree.Kind.FUNCTION_DECLARATION, (Object)Tree.Kind.METHOD, (Object)Tree.Kind.SET_METHOD, (Object)Tree.Kind.GET_METHOD, (Object)Tree.Kind.GENERATOR_METHOD, (Object[])new Tree.Kind[]{Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.ARROW_FUNCTION});

    private CheckUtils() {
    }

    public static Tree.Kind[] assignmentExpressionArray() {
        return (Tree.Kind[])ASSIGNMENT_EXPRESSION.toArray((Object[])new Tree.Kind[ASSIGNMENT_EXPRESSION.size()]);
    }

    public static boolean isAssignmentExpression(AstNode astNode) {
        return ASSIGNMENT_EXPRESSION.contains((Object)astNode.getType());
    }

    public static Tree.Kind[] postfixExpressionArray() {
        return (Tree.Kind[])POSTFIX_EXPRESSION.toArray((Object[])new Tree.Kind[POSTFIX_EXPRESSION.size()]);
    }

    public static boolean isPostfixExpression(AstNodeType type) {
        return POSTFIX_EXPRESSION.contains((Object)type);
    }

    public static boolean isPostfixExpression(AstNode astNodeType) {
        return POSTFIX_EXPRESSION.contains((Object)astNodeType.getType());
    }

    public static Tree.Kind[] relationalExpressionArray() {
        return (Tree.Kind[])RELATIONAL_EXPRESSION.toArray((Object[])new Tree.Kind[RELATIONAL_EXPRESSION.size()]);
    }

    public static boolean isRelationalExpression(AstNodeType type) {
        return RELATIONAL_EXPRESSION.contains((Object)type);
    }

    public static Tree.Kind[] prefixExpressionArray() {
        return (Tree.Kind[])PREFIX_EXPRESSION.toArray((Object[])new Tree.Kind[PREFIX_EXPRESSION.size()]);
    }

    public static boolean isPrefixExpression(AstNode astNode) {
        return PREFIX_EXPRESSION.contains((Object)astNode.getType());
    }

    public static Tree.Kind[] equalityExpressionArray() {
        return (Tree.Kind[])EQUALITY_EXPRESSION.toArray((Object[])new Tree.Kind[EQUALITY_EXPRESSION.size()]);
    }

    public static boolean isEqualityExpression(AstNode astNode) {
        return EQUALITY_EXPRESSION.contains((Object)astNode.getType());
    }

    public static boolean isEqualityExpression(AstNodeType type) {
        return EQUALITY_EXPRESSION.contains((Object)type);
    }

    public static Tree.Kind[] functionNodesArray() {
        return (Tree.Kind[])FUNCTION_NODES.toArray((Object[])new Tree.Kind[FUNCTION_NODES.size()]);
    }

    public static boolean isFunction(AstNode astNode) {
        return FUNCTION_NODES.contains((Object)astNode.getType());
    }

    public static Tree.Kind[] iterationStatementsArray() {
        return (Tree.Kind[])ITERATION_STATEMENTS.toArray((Object[])new Tree.Kind[ITERATION_STATEMENTS.size()]);
    }

    public static boolean isIterationStatement(AstNode astNode) {
        return ITERATION_STATEMENTS.contains((Object)astNode.getType());
    }

    public static String asString(Tree tree) {
        List tokens = ((JavaScriptTree)tree).getTokens();
        StringBuilder sb = new StringBuilder();
        Token prevToken = null;
        for (Token token : tokens) {
            if (prevToken != null && !CheckUtils.areAdjacent(prevToken, token)) {
                sb.append(" ");
            }
            sb.append(token.getOriginalValue());
            prevToken = token;
        }
        return sb.toString();
    }

    private static boolean areAdjacent(Token prevToken, Token token) {
        return prevToken.getColumn() + prevToken.getOriginalValue().length() == token.getColumn();
    }
}

