/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.javascript.model.interfaces.expression.NewExpressionTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="ArrayAndObjectConstructors", name="Array and Object constructors should not be used", priority=Priority.MAJOR, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ArrayAndObjectConstructorsCheck
extends BaseTreeVisitor {
    public void visitNewExpression(NewExpressionTree tree) {
        String next;
        ExpressionTree expression = tree.expression();
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && ("Array".equals(next = ((IdentifierTree)expression).name()) || "Object".equals(next))) {
            this.getContext().addIssue((CodeVisitor)this, (Tree)tree, String.format("Use a literal instead of the %s constructor.", next));
        }
        super.visitNewExpression(tree);
    }
}

