/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.BinaryExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.LiteralTree;
import org.sonar.javascript.model.interfaces.expression.UnaryExpressionTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S1125", name="Literal boolean values should not be used in condition expressions", priority=Priority.MINOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class BooleanEqualityComparisonCheck
extends BaseTreeVisitor {
    private static final Tree.Kind[] BINARY_OPERATORS = new Tree.Kind[]{Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR, Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO};

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
            this.visitExpression(tree.expression());
        }
        super.visitUnaryExpression(tree);
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (tree.is(BINARY_OPERATORS)) {
            this.visitExpression(tree.leftOperand());
            this.visitExpression(tree.rightOperand());
        }
        super.visitBinaryExpression(tree);
    }

    private void visitExpression(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL})) {
            String message = String.format("Remove the literal \"%s\" boolean value.", ((LiteralTree)expression).value());
            this.getContext().addIssue((CodeVisitor)this, (Tree)expression, message);
        }
    }
}

