/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractJQueryCheck;
import org.sonar.javascript.model.implementations.expression.DotMemberExpressionTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.CallExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.javascript.model.interfaces.expression.MemberExpressionTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S2770", name="Deprecated jQuery methods should not be used", priority=Priority.MAJOR, tags={"jquery", "obsolete"})
@SqaleSubCharacteristic(value="SOFTWARE_RELATED_PORTABILITY")
@SqaleConstantRemediation(value="20min")
public class DeprecatedJQueryAPICheck
extends AbstractJQueryCheck {
    private static final String MESSAGE = "Remove this use of \"%s\", which is deprecated.";
    private static final List<String> JQUERY_PROPERTIES = ImmutableList.of((Object)"boxModel", (Object)"browser", (Object)"support");
    private static final List<String> JQUERY_METHODS = ImmutableList.of((Object)"sub");
    private static final List<String> SELECTOR_PROPERTIES = ImmutableList.of((Object)"context", (Object)"afterSelector");
    private static final List<String> SELECTOR_METHODS = ImmutableList.of((Object)"andSelf", (Object)"die", (Object)"error", (Object)"live", (Object)"load", (Object)"size", (Object)"unload");

    public void visitCallExpression(CallExpressionTree tree) {
        String parentheses = "()";
        this.checkSelectorProperty(tree.callee(), SELECTOR_METHODS, parentheses);
        this.checkJQueryProperty(tree.callee(), JQUERY_METHODS, parentheses);
        super.visitCallExpression(tree);
    }

    public void visitMemberExpression(MemberExpressionTree tree) {
        String parentheses = "";
        this.checkSelectorProperty((ExpressionTree)tree, SELECTOR_PROPERTIES, parentheses);
        this.checkJQueryProperty((ExpressionTree)tree, JQUERY_PROPERTIES, parentheses);
        super.visitMemberExpression(tree);
    }

    private boolean isJQueryObject(ExpressionTree object) {
        return object.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && this.isJQueryObject(((IdentifierTree)object).name());
    }

    private void checkJQueryProperty(ExpressionTree expressionTree, List<String> deprecated, String parentheses) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            ExpressionTree object = ((DotMemberExpressionTreeImpl)expressionTree).object();
            ExpressionTree property = ((DotMemberExpressionTreeImpl)expressionTree).property();
            if (this.isJQueryObject(object) && this.propertyIsDeprecated(property, deprecated)) {
                this.getContext().addIssue((CodeVisitor)this, (Tree)property, String.format(MESSAGE, ((IdentifierTree)property).name() + parentheses));
            }
        }
    }

    private void checkSelectorProperty(ExpressionTree expressionTree, List<String> deprecated, String parentheses) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            ExpressionTree object = ((DotMemberExpressionTreeImpl)expressionTree).object();
            ExpressionTree property = ((DotMemberExpressionTreeImpl)expressionTree).property();
            if (this.isMultiLevelSelector(object) && this.propertyIsDeprecated(property, deprecated)) {
                this.getContext().addIssue((CodeVisitor)this, (Tree)property, String.format(MESSAGE, ((IdentifierTree)property).name() + parentheses));
            }
        }
    }

    private boolean propertyIsDeprecated(ExpressionTree property, List<String> deprecated) {
        if (property.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_NAME})) {
            IdentifierTree identifier = (IdentifierTree)property;
            return deprecated.contains(identifier.name());
        }
        return false;
    }
}

