/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.implementations.statement.IfStatementTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="ElseIfWithoutElse", name="\"if ... else if\" constructs shall be terminated with an \"else\" clause", priority=Priority.MAJOR, tags={"cert", "misra"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ElseIfWithoutElseCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.IF_STATEMENT});
    }

    public void visitNode(AstNode node) {
        IfStatementTreeImpl ifStmt = (IfStatementTreeImpl)node;
        if (this.isElseIf((AstNode)ifStmt) && !ifStmt.hasElse()) {
            this.getContext().createLineViolation((CodeCheck)this, "Add the missing \"else\" clause.", node, new Object[0]);
        }
    }

    private boolean isElseIf(AstNode node) {
        return node.getParent().is(new AstNodeType[]{Tree.Kind.ELSE_CLAUSE});
    }
}

