/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.model.implementations.declaration.MethodDeclarationTreeImpl;
import org.sonar.javascript.model.implementations.expression.FunctionExpressionTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.statement.BlockTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="EmptyBlock", name="Nested blocks of code should not be left empty", priority=Priority.MAJOR, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class EmptyBlockCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.BLOCK});
    }

    public void visitNode(AstNode astNode) {
        if (!EmptyBlockCheck.isFunctionBody(astNode) && ((BlockTree)astNode).statements().isEmpty() && !EmptyBlockCheck.hasComment(astNode)) {
            this.getContext().createLineViolation((CodeCheck)this, "Either remove or fill this block of code.", astNode, new Object[0]);
        }
    }

    private static boolean hasComment(AstNode blockNode) {
        return blockNode.getFirstChild(new AstNodeType[]{EcmaScriptPunctuator.RCURLYBRACE}).getToken().hasTrivia();
    }

    private static boolean isFunctionBody(AstNode block) {
        AstNode parent = block.getParent();
        return parent instanceof MethodDeclarationTreeImpl || parent instanceof FunctionExpressionTreeImpl || parent.is(new AstNodeType[]{Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_DECLARATION});
    }
}

