/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.ast.visitors.SyntacticEquivalence;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.AssignmentExpressionTree;
import org.sonar.javascript.model.interfaces.expression.CallExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.javascript.model.interfaces.expression.MemberExpressionTree;
import org.sonar.javascript.model.interfaces.expression.UnaryExpressionTree;
import org.sonar.javascript.model.interfaces.statement.ForStatementTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S1994", name="\"for\" loop incrementers should modify the variable being tested in the loop's stop condition", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class ForLoopConditionAndUpdateCheck
extends BaseTreeVisitor {
    public void visitForStatement(ForStatementTree forStatement) {
        List<ExpressionTree> updatedExpressions = this.updatedExpressions(forStatement.update());
        ExpressionTree condition = forStatement.condition();
        if (!updatedExpressions.isEmpty() && condition != null) {
            ConditionVisitor conditionVisitor = new ConditionVisitor(updatedExpressions);
            condition.accept((TreeVisitor)conditionVisitor);
            if (!conditionVisitor.foundUpdatedExpression) {
                String updated = this.expressionList(updatedExpressions);
                String tested = this.expressionList(conditionVisitor.testedExpressions);
                String message = String.format("This loop's stop condition tests \"%s\" but the incrementer updates \"%s\".", tested, updated);
                this.getContext().addIssue((CodeVisitor)this, (Tree)forStatement, message);
            }
        }
        super.visitForStatement(forStatement);
    }

    private String expressionList(List<ExpressionTree> expressions) {
        ArrayList names = Lists.newArrayList();
        for (ExpressionTree expression : expressions) {
            names.add(CheckUtils.asString((Tree)expression));
        }
        return Joiner.on((String)", ").join((Iterable)names);
    }

    private static IdentifierTree callee(CallExpressionTree tree) {
        ExpressionTree callee = tree.callee();
        while (callee.is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            callee = ((MemberExpressionTree)callee).object();
        }
        if (callee.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && !callee.equals(tree.callee())) {
            return (IdentifierTree)callee;
        }
        return null;
    }

    private List<ExpressionTree> updatedExpressions(ExpressionTree expression) {
        if (expression == null) {
            return ImmutableList.of();
        }
        UpdateVisitor visitor = new UpdateVisitor();
        expression.accept((TreeVisitor)visitor);
        return visitor.updatedExpressions;
    }

    private static class ConditionVisitor
    extends BaseTreeVisitor {
        private List<ExpressionTree> updatedExpressions;
        private List<ExpressionTree> testedExpressions = Lists.newArrayList();
        private Deque<MemberExpressionTree> memberExpressions = new ArrayDeque<MemberExpressionTree>();
        private boolean foundUpdatedExpression = false;

        public ConditionVisitor(List<ExpressionTree> updatedExpressions) {
            this.updatedExpressions = updatedExpressions;
        }

        public void visitIdentifier(IdentifierTree tree) {
            this.checkForUpdate((ExpressionTree)tree);
        }

        public void visitMemberExpression(MemberExpressionTree tree) {
            this.checkForUpdate((ExpressionTree)tree);
            this.memberExpressions.push(tree);
            super.visitMemberExpression(tree);
            this.memberExpressions.pop();
        }

        public void visitCallExpression(CallExpressionTree tree) {
            IdentifierTree callee = ForLoopConditionAndUpdateCheck.callee(tree);
            if (callee != null) {
                this.checkForUpdate((ExpressionTree)callee);
            } else {
                this.logTestedExpression(tree.callee());
            }
            this.scan((Tree)tree.arguments());
        }

        private void checkForUpdate(ExpressionTree tree) {
            this.logTestedExpression(tree);
            for (ExpressionTree updatedExpression : this.updatedExpressions) {
                if (!SyntacticEquivalence.areEquivalent((Tree)updatedExpression, (Tree)tree)) continue;
                this.foundUpdatedExpression = true;
            }
        }

        private void logTestedExpression(ExpressionTree tree) {
            if (this.memberExpressions.isEmpty()) {
                this.testedExpressions.add(tree);
            }
        }
    }

    private static class UpdateVisitor
    extends BaseTreeVisitor {
        private final List<ExpressionTree> updatedExpressions = Lists.newArrayList();

        private UpdateVisitor() {
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            this.updatedExpressions.add(tree.variable());
            super.visitAssignmentExpression(tree);
        }

        public void visitUnaryExpression(UnaryExpressionTree tree) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT, Tree.Kind.POSTFIX_DECREMENT, Tree.Kind.PREFIX_INCREMENT, Tree.Kind.PREFIX_DECREMENT})) {
                this.updatedExpressions.add(tree.expression());
            }
            super.visitUnaryExpression(tree);
        }

        public void visitCallExpression(CallExpressionTree tree) {
            IdentifierTree callee = ForLoopConditionAndUpdateCheck.callee(tree);
            if (callee != null) {
                this.updatedExpressions.add((ExpressionTree)callee);
            }
            super.visitCallExpression(tree);
        }
    }
}

