/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.resolve.Symbol;
import org.sonar.javascript.ast.resolve.SymbolModel;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.model.interfaces.declaration.ScriptTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="FutureReservedWords", name="\"future reserved words\" should not be used as identifiers", priority=Priority.CRITICAL, tags={"lock-in", "pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LANGUAGE_RELATED_PORTABILITY")
@SqaleConstantRemediation(value="5min")
public class FutureReservedWordsCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Rename \"%s\" identifier to prevent potential conflicts with future evolutions of the JavaScript language.";
    private static final Set<String> FUTURE_RESERVED_WORDS = ImmutableSet.of((Object)"implements", (Object)"interface", (Object)"package", (Object)"private", (Object)"protected", (Object)"public", (Object[])new String[]{"enum", "class", "const", "export", "extends", "import", "super", "let", "static", "yield", "await"});

    public void visitScript(ScriptTree tree) {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        List symbols = symbolModel.getSymbols(new Symbol.Kind[0]);
        for (Symbol symbol : symbols) {
            if (!FUTURE_RESERVED_WORDS.contains(symbol.name())) continue;
            this.getContext().addIssue((CodeVisitor)this, symbol.getFirstDeclaration().tree(), String.format(MESSAGE, symbol.name()));
        }
    }
}

