/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.ast.resolve.Symbol;
import org.sonar.javascript.ast.resolve.SymbolModel;
import org.sonar.javascript.ast.resolve.Usage;
import org.sonar.javascript.checks.AbstractJQueryCheck;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.InitializedBindingElementTree;
import org.sonar.javascript.model.interfaces.declaration.ScriptTree;
import org.sonar.javascript.model.interfaces.expression.AssignmentExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S2713", name="JQuery cache variables should comply with a convention name", priority=Priority.MINOR, tags={"jquery", "convention"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class JQueryVarNameConventionCheck
extends AbstractJQueryCheck {
    private static final String MESSAGE = "Rename variable \"%s\" to match the regular expression %s.";
    private static final String DEFAULT_FORMAT = "^\\$[a-z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", description="Regular expression used to check the variable names against", defaultValue="^\\$[a-z][a-zA-Z0-9]*$")
    private String format = "^\\$[a-z][a-zA-Z0-9]*$";

    public void setFormat(String format) {
        this.format = format;
    }

    public void visitScript(ScriptTree tree) {
        Pattern pattern = Pattern.compile(this.format);
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        List symbols = symbolModel.getSymbols(new Symbol.Kind[]{Symbol.Kind.VARIABLE});
        for (Symbol symbol : symbols) {
            Tree firstJQueryStorage = this.getJQueryStorage(symbol, symbolModel);
            if (firstJQueryStorage == null || pattern.matcher(symbol.name()).matches()) continue;
            this.getContext().addIssue((CodeVisitor)this, firstJQueryStorage, String.format(MESSAGE, symbol.name(), this.format));
        }
    }

    @Nullable
    private Tree getJQueryStorage(Symbol symbol, SymbolModel symbolModel) {
        Collection usages = symbolModel.getUsageFor(symbol);
        for (Usage usage : usages) {
            if (!usage.kind().equals((Object)Usage.Kind.WRITE)) continue;
            ExpressionTree expressionTree = null;
            Tree usageTree = usage.usageTree();
            if (usageTree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
                expressionTree = ((AssignmentExpressionTree)usageTree).expression();
            } else if (usageTree.is(new Tree.Kind[]{Tree.Kind.INITIALIZED_BINDING_ELEMENT})) {
                expressionTree = ((InitializedBindingElementTree)usageTree).right();
            }
            if (expressionTree == null || !this.isSelector(expressionTree)) continue;
            return usageTree;
        }
        return null;
    }
}

