/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="OctalNumber", name="Octal values should not be used", priority=Priority.MAJOR, tags={"cert", "misra", "pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class OctalNumberCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptTokenType.NUMERIC_LITERAL});
    }

    public void visitNode(AstNode astNode) {
        String value = astNode.getTokenValue();
        if (value.length() > 1 && value.startsWith("0")) {
            int newValue;
            try {
                newValue = Integer.parseInt(value, 8);
            }
            catch (NumberFormatException e) {
                return;
            }
            this.getContext().createLineViolation((CodeCheck)this, "Replace the value of the octal number (" + value + ") by its decimal equivalent (" + newValue + ").", astNode, new Object[0]);
        }
    }
}

