/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="OneStatementPerLine", name="Statements should be on separate lines", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class OneStatementPerLineCheck
extends SquidCheck<LexerlessGrammar> {
    private final Map<Integer, Integer> statementsPerLine = Maps.newHashMap();

    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.VARIABLE_STATEMENT, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.IF_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.BREAK_STATEMENT, Tree.Kind.RETURN_STATEMENT, Tree.Kind.WITH_STATEMENT, Tree.Kind.SWITCH_STATEMENT, Tree.Kind.THROW_STATEMENT, Tree.Kind.TRY_STATEMENT, Tree.Kind.DEBUGGER_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        int line = astNode.getTokenLine();
        if (!this.statementsPerLine.containsKey(line)) {
            this.statementsPerLine.put(line, 0);
        }
        this.statementsPerLine.put(line, this.statementsPerLine.get(line) + 1);
    }

    public void visitFile(AstNode astNode) {
        this.statementsPerLine.clear();
    }

    public void leaveFile(AstNode astNode) {
        for (Map.Entry<Integer, Integer> statementsAtLine : this.statementsPerLine.entrySet()) {
            if (statementsAtLine.getValue() <= 1) continue;
            this.getContext().createLineViolation((CodeCheck)this, "At most one statement is allowed per line, but {0} statements were found on this line.", statementsAtLine.getKey().intValue(), new Object[]{statementsAtLine.getValue()});
        }
    }
}

