/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.MethodDeclarationTree;
import org.sonar.javascript.model.interfaces.statement.ReturnStatementTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S2432", name="Setters should not return values", priority=Priority.CRITICAL, tags={"bug"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ReturnInSetterCheck
extends BaseTreeVisitor {
    private final TreeVisitor forbiddenReturnVisitor = new ForbiddenReturnVisitor();

    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.SET_METHOD})) {
            tree.body().accept(this.forbiddenReturnVisitor);
        }
        super.visitMethodDeclaration(tree);
    }

    private class ForbiddenReturnVisitor
    extends BaseTreeVisitor {
        private ForbiddenReturnVisitor() {
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            if (tree.expression() != null) {
                ReturnInSetterCheck check = ReturnInSetterCheck.this;
                check.getContext().addIssue((CodeVisitor)check, (Tree)tree, "Remove this return statement.");
            }
            super.visitReturnStatement(tree);
        }
    }
}

