/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.ast.visitors.SyntacticEquivalence;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.AssignmentExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S1656", name="Variables should not be self-assigned", priority=Priority.MAJOR, tags={"bug", "cert"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="3min")
public class SelfAssignmentCheck
extends BaseTreeVisitor {
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        ExpressionTree variable = tree.variable();
        if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && SyntacticEquivalence.areEquivalent((Tree)variable, (Tree)tree.expression())) {
            this.getContext().addIssue((CodeVisitor)this, (Tree)tree, "Remove or correct this useless self-assignment.");
        }
        super.visitAssignmentExpression(tree);
    }
}

