/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="Semicolon", name="Each statement should end with a semicolon", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="1min")
public class SemicolonCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.EOS, EcmaScriptGrammar.EOS_NO_LB});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.getFirstChild(new AstNodeType[]{EcmaScriptPunctuator.SEMI}) == null) {
            this.getContext().createLineViolation((CodeCheck)this, "Add a semicolon at the end of this statement.", astNode.getParent(), new Object[0]);
        }
    }
}

