/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.apache.commons.lang.StringUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.checks.utils.BackboneCheckUtils;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.CallExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.LiteralTree;
import org.sonar.javascript.model.interfaces.expression.ObjectLiteralTree;
import org.sonar.javascript.model.interfaces.expression.PairPropertyTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S2508", name="The names of model properties should not contains spaces", priority=Priority.CRITICAL, tags={"backbone", "bug"})
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class SpaceInModelPropertyNameCheck
extends BaseTreeVisitor {
    public void visitCallExpression(CallExpressionTree tree) {
        PairPropertyTree defaultsProp;
        Tree parameter;
        if (BackboneCheckUtils.isModelCreation(tree) && !tree.arguments().parameters().isEmpty() && (parameter = (Tree)tree.arguments().parameters().get(0)).is(new Tree.Kind[]{Tree.Kind.OBJECT_LITERAL}) && (defaultsProp = BackboneCheckUtils.getModelProperty((ObjectLiteralTree)parameter, "defaults")) != null && defaultsProp.value().is(new Tree.Kind[]{Tree.Kind.OBJECT_LITERAL})) {
            this.checkForSpaceInPropertyNames((ObjectLiteralTree)defaultsProp.value());
        }
        super.visitCallExpression(tree);
    }

    private void checkForSpaceInPropertyNames(ObjectLiteralTree objectLiteral) {
        for (Tree attribute : objectLiteral.properties()) {
            this.checkSpaceInKey(attribute);
        }
    }

    private void checkSpaceInKey(Tree attribute) {
        ExpressionTree key;
        if (attribute.is(new Tree.Kind[]{Tree.Kind.PAIR_PROPERTY}) && (key = ((PairPropertyTree)attribute).key()).is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && StringUtils.indexOf((String)((LiteralTree)key).value(), (char)' ') >= 0) {
            this.getContext().addIssue((CodeVisitor)this, (Tree)key, "Rename this property to remove the spaces.");
        }
    }
}

