/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="TrailingComment", name="Comments should not be located at the end of lines of code", priority=Priority.INFO, tags={"convention"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class TrailingCommentCheck
extends SquidCheck<LexerlessGrammar>
implements AstAndTokenVisitor {
    private static final String DEFAULT_LEGAL_COMMENT_PATTERN = "^//\\s*+[^\\s]++$";
    @RuleProperty(key="legalCommentPattern", description="Pattern for text of trailing comments that are allowed.", defaultValue="^//\\s*+[^\\s]++$")
    private String legalCommentPattern = "^//\\s*+[^\\s]++$";
    private Pattern pattern;
    private int previousTokenLine;

    public void visitFile(AstNode astNode) {
        this.previousTokenLine = -1;
        this.pattern = Pattern.compile(this.legalCommentPattern);
    }

    public void visitToken(Token token) {
        for (Trivia trivia : token.getTrivia()) {
            String comment;
            if (!trivia.isComment() || trivia.getToken().getLine() != this.previousTokenLine || !(comment = trivia.getToken().getValue()).startsWith("//") || this.pattern.matcher(comment).matches()) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Move this trailing comment on the previous empty line.", this.previousTokenLine, new Object[0]);
        }
        this.previousTokenLine = token.getLine();
    }

    public void setLegalCommentPattern(String pattern) {
        this.legalCommentPattern = pattern;
    }
}

