/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.resolve.Scope;
import org.sonar.javascript.ast.resolve.Symbol;
import org.sonar.javascript.ast.resolve.SymbolDeclaration;
import org.sonar.javascript.ast.resolve.SymbolModel;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.model.interfaces.declaration.ScriptTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S2137", name="Local variables should not shadow \"undefined\"", priority=Priority.CRITICAL, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class UndefinedShadowingCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Rename this variable.";

    public void visitScript(ScriptTree tree) {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        List symbols = symbolModel.getSymbols("undefined");
        for (Symbol symbol : symbols) {
            Scope scope = symbolModel.getScopeFor(symbol);
            if (scope.equals(scope.globalScope()) || !symbol.getFirstDeclaration().is(SymbolDeclaration.Kind.VARIABLE_DECLARATION)) continue;
            this.getContext().addIssue((CodeVisitor)this, symbol.getFirstDeclaration().tree(), MESSAGE);
        }
    }
}

