/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.resolve.Scope;
import org.sonar.javascript.ast.resolve.Symbol;
import org.sonar.javascript.ast.resolve.SymbolModel;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.ScriptTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="UnusedFunctionArgument", name="Unused function parameters should be removed", priority=Priority.MAJOR, tags={"misra", "unused"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class UnusedFunctionArgumentCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Remove the unused function parameter%s \"%s\".";

    public void visitScript(ScriptTree tree) {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        Collection scopes = symbolModel.getScopes();
        for (Scope scope : scopes) {
            this.visitScope(symbolModel, scope);
        }
    }

    private void visitScope(SymbolModel symbolModel, Scope scope) {
        if (this.buildInArgumentsUsed(symbolModel, scope) || scope.getTree().is(new Tree.Kind[]{Tree.Kind.SET_METHOD})) {
            return;
        }
        List arguments = scope.getSymbols(Symbol.Kind.PARAMETER);
        List<Symbol> unusedArguments = this.getUnusedArguments(arguments, symbolModel);
        if (!unusedArguments.isEmpty()) {
            String ending = unusedArguments.size() == 1 ? "" : "s";
            this.getContext().addIssue((CodeVisitor)this, scope.getTree(), String.format(MESSAGE, ending, this.getListOfArguments(unusedArguments)));
        }
    }

    private List<Symbol> getUnusedArguments(List<Symbol> arguments, SymbolModel symbolModel) {
        LinkedList<Symbol> unusedArguments = new LinkedList<Symbol>();
        Collections.sort(arguments, new PositionComparator());
        List<Boolean> usageInfo = this.getUsageInfo(symbolModel, arguments);
        boolean usedAfter = false;
        for (int i = arguments.size() - 1; i >= 0; --i) {
            if (usageInfo.get(i).booleanValue()) {
                usedAfter = true;
                continue;
            }
            if (usedAfter) continue;
            unusedArguments.add(0, arguments.get(i));
        }
        return unusedArguments;
    }

    private boolean buildInArgumentsUsed(SymbolModel symbolModel, Scope scope) {
        Symbol argumentsBuildInVariable = scope.lookupSymbol("arguments");
        if (argumentsBuildInVariable == null) {
            return false;
        }
        boolean isUsed = !symbolModel.getUsageFor(argumentsBuildInVariable).isEmpty();
        return argumentsBuildInVariable.buildIn() && isUsed;
    }

    private List<Boolean> getUsageInfo(SymbolModel symbolModel, List<Symbol> symbols) {
        LinkedList<Boolean> result = new LinkedList<Boolean>();
        for (Symbol symbol : symbols) {
            if (symbolModel.getUsageFor(symbol).isEmpty()) {
                result.add(false);
                continue;
            }
            result.add(true);
        }
        return result;
    }

    private String getListOfArguments(List<Symbol> unusedArguments) {
        StringBuilder result = new StringBuilder();
        for (Symbol symbol : unusedArguments) {
            result.append(symbol.name());
            result.append(", ");
        }
        return result.toString().replaceFirst(", $", "");
    }

    private class PositionComparator
    implements Comparator<Symbol> {
        private PositionComparator() {
        }

        private int getLine(Symbol symbol) {
            return ((JavaScriptTree)symbol.getFirstDeclaration().tree()).getLine();
        }

        private int getColumn(Symbol symbol) {
            return ((JavaScriptTree)symbol.getFirstDeclaration().tree()).getToken().getColumn();
        }

        @Override
        public int compare(Symbol symbol1, Symbol symbol2) {
            int lineCompare = Integer.compare(this.getLine(symbol1), this.getLine(symbol2));
            if (lineCompare == 0) {
                return Integer.compare(this.getColumn(symbol1), this.getColumn(symbol2));
            }
            return lineCompare;
        }
    }
}

