/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.resolve.Symbol;
import org.sonar.javascript.ast.resolve.SymbolModel;
import org.sonar.javascript.ast.resolve.Usage;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.ScriptTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="VariableDeclarationAfterUsage", name="Variables should be declared before they are used", priority=Priority.MAJOR, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class VariableDeclarationAfterUsageCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Variable '%s' referenced before declaration.";

    public void visitScript(ScriptTree tree) {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        List symbols = symbolModel.getSymbols(new Symbol.Kind[]{Symbol.Kind.VARIABLE});
        for (Symbol symbol : symbols) {
            this.visitSymbol(symbolModel, symbol);
        }
    }

    private void visitSymbol(SymbolModel symbolModel, Symbol symbol) {
        LinkedList usages = new LinkedList(symbolModel.getUsageFor(symbol));
        if (!usages.isEmpty()) {
            Collections.sort(usages, new LineComparator());
            int declarationLine = ((JavaScriptTree)symbol.getFirstDeclaration().tree()).getLine();
            Usage firstUsage = (Usage)usages.get(0);
            int firstUsageLine = this.getLine(firstUsage);
            if (firstUsageLine < declarationLine) {
                this.getContext().addIssue((CodeVisitor)this, (Tree)firstUsage.symbolTree(), String.format(MESSAGE, symbol.name()));
            }
        }
    }

    private int getLine(Usage usage) {
        return ((JavaScriptTree)usage.symbolTree()).getLine();
    }

    private class LineComparator
    implements Comparator<Usage> {
        private LineComparator() {
        }

        @Override
        public int compare(Usage usage1, Usage usage2) {
            return Integer.compare(VariableDeclarationAfterUsageCheck.this.getLine(usage1), VariableDeclarationAfterUsageCheck.this.getLine(usage2));
        }
    }
}

