/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.resolve.Scope;
import org.sonar.javascript.ast.resolve.Symbol;
import org.sonar.javascript.ast.resolve.SymbolModel;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.interfaces.declaration.ScriptTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="VariableShadowing", name="Variables should not be shadowed", priority=Priority.MAJOR, tags={"pitfall"})
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="10min")
public class VariableShadowingCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "\"%s\" hides or potentially hides a variable declared in an outer scope at line %s.";

    public void visitScript(ScriptTree tree) {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        List symbols = symbolModel.getSymbols(new Symbol.Kind[]{Symbol.Kind.VARIABLE, Symbol.Kind.PARAMETER});
        for (Symbol symbol : symbols) {
            this.visitSymbol(symbolModel, symbol);
        }
    }

    private void visitSymbol(SymbolModel symbolModel, Symbol symbol) {
        if ("arguments".equals(symbol.name()) && symbol.buildIn()) {
            return;
        }
        Scope scope = symbolModel.getScopeFor(symbol);
        if (scope.outer() != null) {
            Symbol localSymbol = scope.lookupSymbol(symbol.name());
            Symbol outerSymbol = scope.outer().lookupSymbol(symbol.name());
            if (localSymbol != null && outerSymbol != null) {
                String message = String.format(MESSAGE, symbol.name(), ((JavaScriptTree)outerSymbol.getFirstDeclaration().tree()).getLine());
                this.getContext().addIssue((CodeVisitor)this, symbol.getFirstDeclaration().tree(), message);
            }
        }
    }
}

