/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.matcher;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.BacktrackingEvent;
import com.sonar.sslr.impl.ParsingState;
import com.sonar.sslr.impl.matcher.Matcher;
import com.sonar.sslr.impl.matcher.MemoizedMatcher;

public final class BridgeMatcher
extends MemoizedMatcher {
    private final TokenType from;
    private final TokenType to;

    protected BridgeMatcher(TokenType from, TokenType to) {
        super(new Matcher[0]);
        this.from = from;
        this.to = to;
    }

    protected AstNode matchWorker(ParsingState parsingState) {
        Token token = parsingState.peekToken(parsingState.lexerIndex, this);
        if (this.from == token.getType()) {
            AstNode astNode = new AstNode(null, "bridgeMatcher", parsingState.peekTokenIfExists(parsingState.lexerIndex, this));
            int bridgeLevel = 0;
            do {
                token = parsingState.popToken(this);
                astNode.addChild(new AstNode(token));
                if (token.getType() == this.from) {
                    ++bridgeLevel;
                }
                if (token.getType() != this.to) continue;
                --bridgeLevel;
            } while (token.getType() != this.to || bridgeLevel != 0);
            return astNode;
        }
        throw BacktrackingEvent.create();
    }

    public String toString() {
        return "bridge(" + this.from.getName() + ", " + this.to.getName() + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getClass().hashCode();
        result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
        result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BridgeMatcher other = (BridgeMatcher)obj;
        if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
            return false;
        }
        return !(this.to == null ? other.to != null : !this.to.equals(other.to));
    }
}

