/*
 * Decompiled with CFR 0.152.
 */
package com.sonar.sslr.impl.matcher;

import com.sonar.sslr.impl.matcher.Matcher;
import com.sonar.sslr.impl.matcher.RuleMatcher;

public final class MatcherTreePrinter {
    private MatcherTreePrinter() {
    }

    public static String print(Matcher matcher) {
        return MatcherTreePrinter.print(matcher, true);
    }

    private static String print(Matcher matcher, boolean expandRule) {
        Matcher[] children = matcher.children;
        StringBuilder result = new StringBuilder(matcher.toString());
        if (MatcherTreePrinter.isRuleImpl(matcher) && expandRule) {
            result.append(".is");
        }
        if (MatcherTreePrinter.hasChildren(children) && MatcherTreePrinter.isNotRuleImplToCollapse(matcher, expandRule)) {
            if (result.length() >= 1 && result.charAt(result.length() - 1) == ')') {
                result.deleteCharAt(result.length() - 1);
                result.append(", ");
            } else {
                result.append("(");
            }
            for (int i = 0; i < children.length; ++i) {
                result.append(MatcherTreePrinter.print(children[i], false));
                if (i >= children.length - 1) continue;
                result.append(", ");
            }
            result.append(")");
        }
        return result.toString();
    }

    private static boolean isNotRuleImplToCollapse(Matcher matcher, boolean expandRule) {
        return !MatcherTreePrinter.isRuleImpl(matcher) || expandRule;
    }

    private static boolean hasChildren(Matcher[] children) {
        return children.length > 0;
    }

    private static boolean isRuleImpl(Matcher matcher) {
        return matcher instanceof RuleMatcher;
    }
}

