/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.colorizer;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;
import org.sonar.colorizer.HtmlCodeBuilder;
import org.sonar.colorizer.HtmlDecorator;
import org.sonar.colorizer.HtmlOptions;
import org.sonar.colorizer.Renderer;
import org.sonar.colorizer.SynhtaxHighlightingException;
import org.sonar.colorizer.TokenizerDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlRenderer
extends Renderer {
    private HtmlOptions options = null;

    public HtmlRenderer(HtmlOptions options) {
        this.options = options;
    }

    public HtmlRenderer() {
        this(HtmlOptions.DEFAULT);
    }

    @Override
    public String render(Reader code, List<? extends Channel<HtmlCodeBuilder>> tokenizers) {
        try {
            ArrayList<Channel<HtmlCodeBuilder>> allTokenizers = new ArrayList<Channel<HtmlCodeBuilder>>();
            HtmlCodeBuilder codeBuilder = new HtmlCodeBuilder();
            HtmlDecorator htmlDecorator = new HtmlDecorator(this.options);
            if (this.options != null && this.options.isGenerateTable()) {
                codeBuilder.appendWithoutTransforming(htmlDecorator.getTagBeginOfFile());
                allTokenizers.add(htmlDecorator);
            }
            allTokenizers.addAll(tokenizers);
            new TokenizerDispatcher(allTokenizers).colorize(new CodeReader(code), codeBuilder);
            if (this.options != null && this.options.isGenerateTable()) {
                codeBuilder.appendWithoutTransforming(htmlDecorator.getTagEndOfFile());
            }
            return codeBuilder.toString();
        }
        catch (Exception e) {
            throw new SynhtaxHighlightingException("Can not render code", e);
        }
    }
}

