/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.CommentAnalyser;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.impl.events.ParsingEventListener;
import com.sonar.sslr.squid.AstScanner;
import com.sonar.sslr.squid.SourceCodeBuilderCallback;
import com.sonar.sslr.squid.SourceCodeBuilderVisitor;
import com.sonar.sslr.squid.SquidAstVisitor;
import com.sonar.sslr.squid.SquidAstVisitorContextImpl;
import com.sonar.sslr.squid.metrics.CommentsVisitor;
import com.sonar.sslr.squid.metrics.ComplexityVisitor;
import com.sonar.sslr.squid.metrics.CounterVisitor;
import com.sonar.sslr.squid.metrics.LinesOfCodeVisitor;
import com.sonar.sslr.squid.metrics.LinesVisitor;
import java.io.File;
import java.util.Collection;
import org.sonar.javascript.EcmaScriptConfiguration;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.javascript.api.EcmaScriptMetric;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.parser.EcmaScriptParser;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceFunction;
import org.sonar.squid.api.SourceProject;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaScriptAstScanner {
    private JavaScriptAstScanner() {
    }

    public static SourceFile scanSingleFile(File file, SquidAstVisitor<EcmaScriptGrammar> ... visitors) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File '" + file + "' not found.");
        }
        AstScanner<EcmaScriptGrammar> scanner = JavaScriptAstScanner.create(new EcmaScriptConfiguration(), visitors);
        scanner.scanFile(file);
        Collection<SourceCode> sources = scanner.getIndex().search(new QueryByType(SourceFile.class));
        if (sources.size() != 1) {
            throw new IllegalStateException("Only one SourceFile was expected whereas " + sources.size() + " has been returned.");
        }
        return (SourceFile)sources.iterator().next();
    }

    public static AstScanner<EcmaScriptGrammar> create(EcmaScriptConfiguration conf, SquidAstVisitor<EcmaScriptGrammar> ... visitors) {
        SquidAstVisitorContextImpl context = new SquidAstVisitorContextImpl(new SourceProject("JavaScript Project"));
        Parser<EcmaScriptGrammar> parser = EcmaScriptParser.create(conf, new ParsingEventListener[0]);
        AstScanner.Builder builder = AstScanner.builder((SquidAstVisitorContextImpl)context).setBaseParser(parser);
        builder.withMetrics((MetricDef[])EcmaScriptMetric.values());
        builder.setCommentAnalyser(new CommentAnalyser(){

            public boolean isBlank(String line) {
                for (int i = 0; i < line.length(); ++i) {
                    if (!Character.isLetterOrDigit(line.charAt(i))) continue;
                    return false;
                }
                return true;
            }

            public String getContents(String comment) {
                return comment.startsWith("//") ? comment.substring(2) : comment.substring(2, comment.length() - 2);
            }
        });
        builder.setFilesMetric((MetricDef)EcmaScriptMetric.FILES);
        builder.withSquidAstVisitor((SquidAstVisitor)new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){

            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                String functionName = astNode.getChild(1).getTokenValue();
                SourceFunction function = new SourceFunction(functionName + ":" + astNode.getToken().getLine());
                function.setStartAtLine(astNode.getTokenLine());
                return function;
            }
        }, new AstNodeType[]{parser.getGrammar().functionDeclaration, parser.getGrammar().functionExpression}));
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)EcmaScriptMetric.FUNCTIONS).subscribeTo(new AstNodeType[]{parser.getGrammar().functionDeclaration, parser.getGrammar().functionExpression}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)new LinesVisitor((MetricDef)EcmaScriptMetric.LINES));
        builder.withSquidAstVisitor((SquidAstVisitor)new LinesOfCodeVisitor((MetricDef)EcmaScriptMetric.LINES_OF_CODE));
        builder.withSquidAstVisitor((SquidAstVisitor)CommentsVisitor.builder().withCommentMetric((MetricDef)EcmaScriptMetric.COMMENT_LINES).withBlankCommentMetric((MetricDef)EcmaScriptMetric.COMMENT_BLANK_LINES).withNoSonar(true).withIgnoreHeaderComment(conf.getIgnoreHeaderComments()).build());
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)EcmaScriptMetric.STATEMENTS).subscribeTo(new AstNodeType[]{parser.getGrammar().statement}).build());
        AstNodeType[] complexityAstNodeType = new AstNodeType[]{parser.getGrammar().functionDeclaration, parser.getGrammar().functionExpression, parser.getGrammar().ifStatement, parser.getGrammar().iterationStatement, parser.getGrammar().switchStatement, parser.getGrammar().caseClause, parser.getGrammar().defaultClause, parser.getGrammar().catch_, parser.getGrammar().returnStatement, parser.getGrammar().throwStatement, EcmaScriptPunctuator.QUERY, EcmaScriptPunctuator.ANDAND, EcmaScriptPunctuator.OROR};
        builder.withSquidAstVisitor((SquidAstVisitor)ComplexityVisitor.builder().setMetricDef((MetricDef)EcmaScriptMetric.COMPLEXITY).subscribeTo(complexityAstNodeType).build());
        for (SquidAstVisitor<EcmaScriptGrammar> visitor : visitors) {
            builder.withSquidAstVisitor(visitor);
        }
        return builder.build();
    }
}

