/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.lexer;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.TokenType;
import com.sonar.sslr.impl.Lexer;
import com.sonar.sslr.impl.channel.BlackHoleChannel;
import com.sonar.sslr.impl.channel.IdentifierAndKeywordChannel;
import com.sonar.sslr.impl.channel.PunctuatorChannel;
import com.sonar.sslr.impl.channel.RegexpChannelBuilder;
import org.sonar.javascript.EcmaScriptConfiguration;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.lexer.EcmaScriptRegexpChannel;

public final class EcmaScriptLexer {
    private static final String EXP = "([Ee][+-]?+[0-9_]++)";
    private static final String BINARY_EXP = "([Pp][+-]?+[0-9_]++)";
    private static final String FLOAT_SUFFIX = "[fFdD]";
    private static final String INT_SUFFIX = "[lL]";

    private EcmaScriptLexer() {
    }

    public static Lexer create() {
        return EcmaScriptLexer.create(new EcmaScriptConfiguration());
    }

    public static Lexer create(EcmaScriptConfiguration conf) {
        return Lexer.builder().withCharset(conf.getCharset()).withFailIfNoChannelToConsumeOneCharacter(true).withChannel(RegexpChannelBuilder.commentRegexp("//[^\\n\\r]*+")).withChannel(RegexpChannelBuilder.commentRegexp("/\\*[\\s\\S]*?\\*/")).withChannel(RegexpChannelBuilder.regexp(GenericTokenType.LITERAL, "\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\"")).withChannel(RegexpChannelBuilder.regexp(GenericTokenType.LITERAL, "'([^'\\\\]*+(\\\\[\\s\\S])?+)*+'")).withChannel(new EcmaScriptRegexpChannel()).withChannel(RegexpChannelBuilder.regexp(EcmaScriptTokenType.NUMERIC_LITERAL, "[0-9]++\\.([0-9]++)?+([Ee][+-]?+[0-9_]++)?+[fFdD]?+")).withChannel(RegexpChannelBuilder.regexp(EcmaScriptTokenType.NUMERIC_LITERAL, "\\.[0-9]++([Ee][+-]?+[0-9_]++)?+[fFdD]?+")).withChannel(RegexpChannelBuilder.regexp(EcmaScriptTokenType.NUMERIC_LITERAL, "[0-9]++[fFdD]")).withChannel(RegexpChannelBuilder.regexp(EcmaScriptTokenType.NUMERIC_LITERAL, "[0-9]++([Ee][+-]?+[0-9_]++)[fFdD]?+")).withChannel(RegexpChannelBuilder.regexp(EcmaScriptTokenType.NUMERIC_LITERAL, "0[xX][0-9a-fA-F]++\\.[0-9a-fA-F_]*+([Pp][+-]?+[0-9_]++)?+[fFdD]?+")).withChannel(RegexpChannelBuilder.regexp(EcmaScriptTokenType.NUMERIC_LITERAL, "0[xX][0-9a-fA-F]++([Pp][+-]?+[0-9_]++)[fFdD]?+")).withChannel(RegexpChannelBuilder.regexp(EcmaScriptTokenType.NUMERIC_LITERAL, "0[xX][0-9a-fA-F]++[lL]?+")).withChannel(RegexpChannelBuilder.regexp(EcmaScriptTokenType.NUMERIC_LITERAL, "0[bB][01]++[lL]?+")).withChannel(RegexpChannelBuilder.regexp(EcmaScriptTokenType.NUMERIC_LITERAL, "[0-9]++[lL]?+")).withChannel(new IdentifierAndKeywordChannel("\\p{javaJavaIdentifierStart}++\\p{javaJavaIdentifierPart}*+", true, new TokenType[][]{EcmaScriptKeyword.values()})).withChannel(new PunctuatorChannel(EcmaScriptPunctuator.values())).withChannel(new BlackHoleChannel("[\\s]")).build();
    }
}

