/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.parser;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.impl.matcher.GrammarFunctions;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.api.EcmaScriptTokenType;

public class EcmaScriptGrammarImpl
extends EcmaScriptGrammar {
    public EcmaScriptGrammarImpl() {
        this.eos.is(GrammarFunctions.Standard.or(GrammarFunctions.Standard.opt(EcmaScriptPunctuator.SEMI), GrammarFunctions.Predicate.next(EcmaScriptPunctuator.RCURLYBRACE), GrammarFunctions.Predicate.next(GenericTokenType.EOF)));
        this.eosNoLb.is(GrammarFunctions.Standard.or(GrammarFunctions.Standard.opt(EcmaScriptPunctuator.SEMI), GrammarFunctions.Predicate.next(EcmaScriptPunctuator.RCURLYBRACE), GrammarFunctions.Predicate.next(GenericTokenType.EOF)));
        this.identifierName.is(GenericTokenType.IDENTIFIER);
        this.literal.is(GrammarFunctions.Standard.or(this.nullLiteral, this.booleanLiteral, EcmaScriptTokenType.NUMERIC_LITERAL, this.stringLiteral, this.regularExpressionLiteral));
        this.nullLiteral.is(EcmaScriptKeyword.NULL);
        this.booleanLiteral.is(GrammarFunctions.Standard.or(EcmaScriptKeyword.TRUE, EcmaScriptKeyword.FALSE));
        this.stringLiteral.is(GenericTokenType.LITERAL);
        this.regularExpressionLiteral.is(EcmaScriptTokenType.REGULAR_EXPRESSION_LITERAL);
        this.expressions();
        this.statements();
        this.functionsAndPrograms();
    }

    private void expressions() {
        this.primaryExpression.is(GrammarFunctions.Standard.or(EcmaScriptKeyword.THIS, GenericTokenType.IDENTIFIER, this.literal, this.arrayLiteral, this.objectLiteral, GrammarFunctions.Standard.and(EcmaScriptPunctuator.LPARENTHESIS, this.expression, EcmaScriptPunctuator.RPARENTHESIS)));
        this.arrayLiteral.is(GrammarFunctions.Standard.or(GrammarFunctions.Standard.and(EcmaScriptPunctuator.LBRACKET, GrammarFunctions.Standard.opt(this.elision), EcmaScriptPunctuator.RBRACKET), GrammarFunctions.Standard.and(EcmaScriptPunctuator.LBRACKET, this.elementList, EcmaScriptPunctuator.RBRACKET), GrammarFunctions.Standard.and(EcmaScriptPunctuator.LBRACKET, this.elementList, EcmaScriptPunctuator.COMMA, GrammarFunctions.Standard.opt(this.elision), EcmaScriptPunctuator.RBRACKET)));
        this.elementList.is(GrammarFunctions.Standard.and(GrammarFunctions.Standard.opt(this.elision), this.assignmentExpression), GrammarFunctions.Standard.o2n(EcmaScriptPunctuator.COMMA, GrammarFunctions.Standard.opt(this.elision), this.assignmentExpression));
        this.elision.is(GrammarFunctions.Standard.one2n(EcmaScriptPunctuator.COMMA));
        this.objectLiteral.is(GrammarFunctions.Standard.or(GrammarFunctions.Standard.and(EcmaScriptPunctuator.LCURLYBRACE, EcmaScriptPunctuator.RCURLYBRACE), GrammarFunctions.Standard.and(EcmaScriptPunctuator.LCURLYBRACE, this.propertyNameAndValueList, EcmaScriptPunctuator.RCURLYBRACE), GrammarFunctions.Standard.and(EcmaScriptPunctuator.LCURLYBRACE, this.propertyNameAndValueList, EcmaScriptPunctuator.COMMA, EcmaScriptPunctuator.RCURLYBRACE)));
        this.propertyNameAndValueList.is(this.propertyAssignment, GrammarFunctions.Standard.o2n(EcmaScriptPunctuator.COMMA, this.propertyAssignment));
        this.propertyAssignment.is(GrammarFunctions.Standard.or(GrammarFunctions.Standard.and(this.propertyName, EcmaScriptPunctuator.COLON, this.assignmentExpression), GrammarFunctions.Standard.and("get", this.propertyName, EcmaScriptPunctuator.LPARENTHESIS, EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, this.functionBody, EcmaScriptPunctuator.RCURLYBRACE), GrammarFunctions.Standard.and("set", this.propertyName, EcmaScriptPunctuator.LPARENTHESIS, this.propertySetParameterList, EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, this.functionBody, EcmaScriptPunctuator.RCURLYBRACE)));
        this.propertyName.is(GrammarFunctions.Standard.or(this.identifierName, this.stringLiteral, EcmaScriptTokenType.NUMERIC_LITERAL));
        this.propertySetParameterList.is(GenericTokenType.IDENTIFIER);
        this.memberExpression.is(GrammarFunctions.Standard.or(this.primaryExpression, this.functionExpression, GrammarFunctions.Standard.and(EcmaScriptKeyword.NEW, this.memberExpression, this.arguments)), GrammarFunctions.Standard.o2n(GrammarFunctions.Standard.or(GrammarFunctions.Standard.and(EcmaScriptPunctuator.LBRACKET, this.expression, EcmaScriptPunctuator.RBRACKET), GrammarFunctions.Standard.and(EcmaScriptPunctuator.DOT, this.identifierName))));
        this.newExpression.is(GrammarFunctions.Standard.or(this.memberExpression, GrammarFunctions.Standard.and(EcmaScriptKeyword.NEW, this.newExpression)));
        this.callExpression.is(GrammarFunctions.Standard.and(this.memberExpression, this.arguments), GrammarFunctions.Standard.o2n(GrammarFunctions.Standard.or(this.arguments, GrammarFunctions.Standard.and(EcmaScriptPunctuator.LBRACKET, this.expression, EcmaScriptPunctuator.RBRACKET), GrammarFunctions.Standard.and(EcmaScriptPunctuator.DOT, this.identifierName))));
        this.arguments.is(GrammarFunctions.Standard.or(GrammarFunctions.Standard.and(EcmaScriptPunctuator.LPARENTHESIS, this.argumentList, EcmaScriptPunctuator.RPARENTHESIS), GrammarFunctions.Standard.and(EcmaScriptPunctuator.LPARENTHESIS, EcmaScriptPunctuator.RPARENTHESIS)));
        this.argumentList.is(this.assignmentExpression, GrammarFunctions.Standard.o2n(EcmaScriptPunctuator.COMMA, this.assignmentExpression));
        this.leftHandSideExpression.is(GrammarFunctions.Standard.or(this.callExpression, this.newExpression));
        this.postfixExpression.is(this.leftHandSideExpression, GrammarFunctions.Standard.opt(GrammarFunctions.Standard.or(EcmaScriptPunctuator.INC, EcmaScriptPunctuator.DEC)));
        this.unaryExpression.is(GrammarFunctions.Standard.or(this.postfixExpression, GrammarFunctions.Standard.and(EcmaScriptKeyword.DELETE, this.unaryExpression), GrammarFunctions.Standard.and(EcmaScriptKeyword.VOID, this.unaryExpression), GrammarFunctions.Standard.and(EcmaScriptKeyword.TYPEOF, this.unaryExpression), GrammarFunctions.Standard.and(EcmaScriptPunctuator.INC, this.unaryExpression), GrammarFunctions.Standard.and(EcmaScriptPunctuator.DEC, this.unaryExpression), GrammarFunctions.Standard.and(EcmaScriptPunctuator.PLUS, this.unaryExpression), GrammarFunctions.Standard.and(EcmaScriptPunctuator.MINUS, this.unaryExpression), GrammarFunctions.Standard.and(EcmaScriptPunctuator.TILDA, this.unaryExpression), GrammarFunctions.Standard.and(EcmaScriptPunctuator.BANG, this.unaryExpression)));
        this.multiplicativeExpression.is(this.unaryExpression, GrammarFunctions.Standard.opt(GrammarFunctions.Standard.or(EcmaScriptPunctuator.STAR, EcmaScriptPunctuator.DIV, EcmaScriptPunctuator.MOD), this.multiplicativeExpression)).skipIfOneChild();
        this.additiveExpression.is(this.multiplicativeExpression, GrammarFunctions.Standard.opt(GrammarFunctions.Standard.or(EcmaScriptPunctuator.PLUS, EcmaScriptPunctuator.MINUS), this.additiveExpression)).skipIfOneChild();
        this.shiftExpression.is(this.additiveExpression, GrammarFunctions.Standard.opt(GrammarFunctions.Standard.or(EcmaScriptPunctuator.SL, EcmaScriptPunctuator.SR, EcmaScriptPunctuator.SR2), this.shiftExpression)).skipIfOneChild();
        this.relationalExpression.is(this.shiftExpression, GrammarFunctions.Standard.opt(GrammarFunctions.Standard.or(EcmaScriptPunctuator.LT, EcmaScriptPunctuator.GT, EcmaScriptPunctuator.LE, EcmaScriptPunctuator.GE, EcmaScriptKeyword.INSTANCEOF, EcmaScriptKeyword.IN), this.relationalExpression)).skipIfOneChild();
        this.relationalExpressionNoIn.is(this.shiftExpression, GrammarFunctions.Standard.opt(GrammarFunctions.Standard.or(EcmaScriptPunctuator.LT, EcmaScriptPunctuator.GT, EcmaScriptPunctuator.LE, EcmaScriptPunctuator.GE, EcmaScriptKeyword.INSTANCEOF), this.relationalExpression)).skipIfOneChild();
        this.equalityExpression.is(this.relationalExpression, GrammarFunctions.Standard.opt(GrammarFunctions.Standard.or(EcmaScriptPunctuator.EQUAL, EcmaScriptPunctuator.NOTEQUAL, EcmaScriptPunctuator.EQUAL2, EcmaScriptPunctuator.NOTEQUAL2), this.equalityExpression)).skipIfOneChild();
        this.equalityExpressionNoIn.is(this.relationalExpressionNoIn, GrammarFunctions.Standard.opt(GrammarFunctions.Standard.or(EcmaScriptPunctuator.EQUAL, EcmaScriptPunctuator.NOTEQUAL, EcmaScriptPunctuator.EQUAL2, EcmaScriptPunctuator.NOTEQUAL2), this.equalityExpressionNoIn)).skipIfOneChild();
        this.bitwiseAndExpression.is(this.equalityExpression, GrammarFunctions.Standard.opt(EcmaScriptPunctuator.AND, this.bitwiseAndExpression)).skipIfOneChild();
        this.bitwiseAndExpressionNoIn.is(this.equalityExpressionNoIn, GrammarFunctions.Standard.opt(EcmaScriptPunctuator.AND, this.bitwiseAndExpressionNoIn)).skipIfOneChild();
        this.bitwiseXorExpression.is(this.bitwiseAndExpression, GrammarFunctions.Standard.opt(EcmaScriptPunctuator.XOR, this.bitwiseXorExpression)).skipIfOneChild();
        this.bitwiseXorExpressionNoIn.is(this.bitwiseAndExpressionNoIn, GrammarFunctions.Standard.opt(EcmaScriptPunctuator.XOR, this.bitwiseXorExpressionNoIn)).skipIfOneChild();
        this.bitwiseOrExpression.is(this.bitwiseXorExpression, GrammarFunctions.Standard.opt(EcmaScriptPunctuator.OR, this.bitwiseOrExpression)).skipIfOneChild();
        this.bitwiseOrExpressionNoIn.is(this.bitwiseXorExpressionNoIn, GrammarFunctions.Standard.opt(EcmaScriptPunctuator.OR, this.bitwiseOrExpressionNoIn)).skipIfOneChild();
        this.logicalAndExpression.is(this.bitwiseOrExpression, GrammarFunctions.Standard.opt(EcmaScriptPunctuator.ANDAND, this.logicalAndExpression)).skipIfOneChild();
        this.logicalAndExpressionNoIn.is(this.bitwiseOrExpressionNoIn, GrammarFunctions.Standard.opt(EcmaScriptPunctuator.ANDAND, this.logicalAndExpressionNoIn)).skipIfOneChild();
        this.logicalOrExpression.is(this.logicalAndExpression, GrammarFunctions.Standard.opt(EcmaScriptPunctuator.OROR, this.logicalOrExpression)).skipIfOneChild();
        this.logicalOrExpressionNoIn.is(this.logicalAndExpressionNoIn, GrammarFunctions.Standard.opt(EcmaScriptPunctuator.OROR, this.logicalOrExpressionNoIn)).skipIfOneChild();
        this.conditionalExpression.is(this.logicalOrExpression, GrammarFunctions.Standard.opt(EcmaScriptPunctuator.QUERY, this.assignmentExpression, EcmaScriptPunctuator.COLON, this.assignmentExpression)).skipIfOneChild();
        this.conditionalExpressionNoIn.is(this.logicalOrExpressionNoIn, GrammarFunctions.Standard.opt(EcmaScriptPunctuator.QUERY, this.assignmentExpression, EcmaScriptPunctuator.COLON, this.assignmentExpressionNoIn)).skipIfOneChild();
        this.assignmentExpression.is(GrammarFunctions.Standard.or(GrammarFunctions.Standard.and(this.leftHandSideExpression, EcmaScriptPunctuator.EQU, this.assignmentExpression), GrammarFunctions.Standard.and(this.leftHandSideExpression, this.assignmentOperator, this.assignmentExpression), this.conditionalExpression)).skipIfOneChild();
        this.assignmentExpressionNoIn.is(GrammarFunctions.Standard.or(GrammarFunctions.Standard.and(this.leftHandSideExpression, EcmaScriptPunctuator.EQU, this.assignmentExpressionNoIn), GrammarFunctions.Standard.and(this.leftHandSideExpression, this.assignmentOperator, this.assignmentExpressionNoIn), this.conditionalExpressionNoIn)).skipIfOneChild();
        this.assignmentOperator.is(GrammarFunctions.Standard.or(EcmaScriptPunctuator.STAR_EQU, EcmaScriptPunctuator.DIV_EQU, EcmaScriptPunctuator.MOD_EQU, EcmaScriptPunctuator.PLUS_EQU, EcmaScriptPunctuator.MINUS_EQU, EcmaScriptPunctuator.SL_EQU, EcmaScriptPunctuator.SR_EQU, EcmaScriptPunctuator.SR_EQU2, EcmaScriptPunctuator.AND_EQU, EcmaScriptPunctuator.XOR_EQU, EcmaScriptPunctuator.OR_EQU));
        this.expression.is(this.assignmentExpression, GrammarFunctions.Standard.o2n(EcmaScriptPunctuator.COMMA, this.assignmentExpression));
        this.expressionNoIn.is(this.assignmentExpressionNoIn, GrammarFunctions.Standard.o2n(EcmaScriptPunctuator.COMMA, this.assignmentExpressionNoIn));
    }

    private void statements() {
        this.statement.is(GrammarFunctions.Standard.or(this.block, this.variableStatement, this.emptyStatement, this.labelledStatement, this.expressionStatement, this.ifStatement, this.iterationStatement, this.continueStatement, this.breakStatement, this.returnStatement, this.withStatement, this.switchStatement, this.throwStatement, this.tryStatement, this.debuggerStatement));
        this.block.is(EcmaScriptPunctuator.LCURLYBRACE, GrammarFunctions.Standard.opt(this.statementList), EcmaScriptPunctuator.RCURLYBRACE);
        this.statementList.is(GrammarFunctions.Standard.one2n(GrammarFunctions.Standard.or(this.statement, EcmaScriptGrammarImpl.permissive(this.functionDeclaration))));
        this.variableStatement.is(EcmaScriptKeyword.VAR, this.variableDeclarationList, this.eos);
        this.variableDeclarationList.is(this.variableDeclaration, GrammarFunctions.Standard.o2n(EcmaScriptPunctuator.COMMA, this.variableDeclaration));
        this.variableDeclarationListNoIn.is(this.variableDeclarationNoIn, GrammarFunctions.Standard.o2n(EcmaScriptPunctuator.COMMA, this.variableDeclarationNoIn));
        this.variableDeclaration.is(GenericTokenType.IDENTIFIER, GrammarFunctions.Standard.opt(this.initialiser));
        this.variableDeclarationNoIn.is(GenericTokenType.IDENTIFIER, GrammarFunctions.Standard.opt(this.initialiserNoIn));
        this.initialiser.is(EcmaScriptPunctuator.EQU, this.assignmentExpression);
        this.initialiserNoIn.is(EcmaScriptPunctuator.EQU, this.assignmentExpressionNoIn);
        this.emptyStatement.is(EcmaScriptPunctuator.SEMI);
        this.expressionStatement.is(GrammarFunctions.Predicate.not(GrammarFunctions.Standard.or(EcmaScriptPunctuator.LCURLYBRACE, EcmaScriptKeyword.FUNCTION)), this.expression, this.eos);
        this.condition.is(this.expression);
        this.ifStatement.is(GrammarFunctions.Standard.or(GrammarFunctions.Standard.and(EcmaScriptKeyword.IF, EcmaScriptPunctuator.LPARENTHESIS, this.condition, EcmaScriptPunctuator.RPARENTHESIS, this.statement, GrammarFunctions.Standard.opt(EcmaScriptKeyword.ELSE, this.statement)), GrammarFunctions.Standard.and(EcmaScriptKeyword.IF, EcmaScriptPunctuator.LPARENTHESIS, this.condition, EcmaScriptPunctuator.RPARENTHESIS, this.statement)));
        this.iterationStatement.is(GrammarFunctions.Standard.or(this.doWhileStatement, this.whileStatement, this.forInStatement, this.forStatement));
        this.doWhileStatement.is(EcmaScriptKeyword.DO, this.statement, EcmaScriptKeyword.WHILE, EcmaScriptPunctuator.LPARENTHESIS, this.condition, EcmaScriptPunctuator.RPARENTHESIS, this.eos);
        this.whileStatement.is(EcmaScriptKeyword.WHILE, EcmaScriptPunctuator.LPARENTHESIS, this.condition, EcmaScriptPunctuator.RPARENTHESIS, this.statement);
        this.forInStatement.is(GrammarFunctions.Standard.or(GrammarFunctions.Standard.and(EcmaScriptKeyword.FOR, EcmaScriptPunctuator.LPARENTHESIS, this.leftHandSideExpression, EcmaScriptKeyword.IN, this.expression, EcmaScriptPunctuator.RPARENTHESIS, this.statement), GrammarFunctions.Standard.and(EcmaScriptKeyword.FOR, EcmaScriptPunctuator.LPARENTHESIS, EcmaScriptKeyword.VAR, this.variableDeclarationListNoIn, EcmaScriptKeyword.IN, this.expression, EcmaScriptPunctuator.RPARENTHESIS, this.statement)));
        this.forStatement.is(GrammarFunctions.Standard.or(GrammarFunctions.Standard.and(EcmaScriptKeyword.FOR, EcmaScriptPunctuator.LPARENTHESIS, GrammarFunctions.Standard.opt(this.expressionNoIn), EcmaScriptPunctuator.SEMI, GrammarFunctions.Standard.opt(this.condition), EcmaScriptPunctuator.SEMI, GrammarFunctions.Standard.opt(this.expression), EcmaScriptPunctuator.RPARENTHESIS, this.statement), GrammarFunctions.Standard.and(EcmaScriptKeyword.FOR, EcmaScriptPunctuator.LPARENTHESIS, EcmaScriptKeyword.VAR, this.variableDeclarationListNoIn, EcmaScriptPunctuator.SEMI, GrammarFunctions.Standard.opt(this.condition), EcmaScriptPunctuator.SEMI, GrammarFunctions.Standard.opt(this.expression), EcmaScriptPunctuator.RPARENTHESIS, this.statement)));
        this.continueStatement.is(GrammarFunctions.Standard.or(GrammarFunctions.Standard.and(EcmaScriptKeyword.CONTINUE, GenericTokenType.IDENTIFIER, this.eos), GrammarFunctions.Standard.and(EcmaScriptKeyword.CONTINUE, this.eosNoLb)));
        this.breakStatement.is(GrammarFunctions.Standard.or(GrammarFunctions.Standard.and(EcmaScriptKeyword.BREAK, GenericTokenType.IDENTIFIER, this.eos), GrammarFunctions.Standard.and(EcmaScriptKeyword.BREAK, this.eosNoLb)));
        this.returnStatement.is(GrammarFunctions.Standard.or(GrammarFunctions.Standard.and(EcmaScriptKeyword.RETURN, this.expression, this.eos), GrammarFunctions.Standard.and(EcmaScriptKeyword.RETURN, this.eosNoLb)));
        this.withStatement.is(EcmaScriptKeyword.WITH, EcmaScriptPunctuator.LPARENTHESIS, this.expression, EcmaScriptPunctuator.RPARENTHESIS, this.statement);
        this.switchStatement.is(EcmaScriptKeyword.SWITCH, EcmaScriptPunctuator.LPARENTHESIS, this.expression, EcmaScriptPunctuator.RPARENTHESIS, this.caseBlock);
        this.caseBlock.is(GrammarFunctions.Standard.or(GrammarFunctions.Standard.and(EcmaScriptPunctuator.LCURLYBRACE, GrammarFunctions.Standard.opt(this.caseClauses), EcmaScriptPunctuator.RCURLYBRACE), GrammarFunctions.Standard.and(EcmaScriptPunctuator.LCURLYBRACE, GrammarFunctions.Standard.opt(this.caseClauses), this.defaultClause, GrammarFunctions.Standard.opt(this.caseClauses), EcmaScriptPunctuator.RCURLYBRACE)));
        this.caseClauses.is(GrammarFunctions.Standard.one2n(this.caseClause));
        this.caseClause.is(EcmaScriptKeyword.CASE, this.expression, EcmaScriptPunctuator.COLON, GrammarFunctions.Standard.opt(this.statementList));
        this.defaultClause.is(EcmaScriptKeyword.DEFAULT, EcmaScriptPunctuator.COLON, GrammarFunctions.Standard.opt(this.statementList));
        this.labelledStatement.is(GenericTokenType.IDENTIFIER, EcmaScriptPunctuator.COLON, this.statement);
        this.throwStatement.is(EcmaScriptKeyword.THROW, this.expression, this.eos);
        this.tryStatement.is(EcmaScriptKeyword.TRY, this.block, GrammarFunctions.Standard.or(GrammarFunctions.Standard.and(this.catch_, GrammarFunctions.Standard.opt(this.finally_)), this.finally_));
        this.catch_.is(EcmaScriptKeyword.CATCH, EcmaScriptPunctuator.LPARENTHESIS, GenericTokenType.IDENTIFIER, EcmaScriptPunctuator.RPARENTHESIS, this.block);
        this.finally_.is(EcmaScriptKeyword.FINALLY, this.block);
        this.debuggerStatement.is(EcmaScriptKeyword.DEBUGGER, this.eos);
    }

    private void functionsAndPrograms() {
        this.functionDeclaration.is(EcmaScriptKeyword.FUNCTION, GenericTokenType.IDENTIFIER, EcmaScriptPunctuator.LPARENTHESIS, GrammarFunctions.Standard.opt(this.formalParameterList), EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, this.functionBody, EcmaScriptPunctuator.RCURLYBRACE);
        this.functionExpression.is(EcmaScriptKeyword.FUNCTION, GrammarFunctions.Standard.opt(GenericTokenType.IDENTIFIER), EcmaScriptPunctuator.LPARENTHESIS, GrammarFunctions.Standard.opt(this.formalParameterList), EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, this.functionBody, EcmaScriptPunctuator.RCURLYBRACE);
        this.formalParameterList.is(GenericTokenType.IDENTIFIER, GrammarFunctions.Standard.o2n(EcmaScriptPunctuator.COMMA, GenericTokenType.IDENTIFIER));
        this.functionBody.is(GrammarFunctions.Standard.opt(this.sourceElements));
        this.program.is(GrammarFunctions.Standard.opt(this.sourceElements), GenericTokenType.EOF);
        this.sourceElements.is(GrammarFunctions.Standard.one2n(this.sourceElement));
        this.sourceElement.is(GrammarFunctions.Standard.or(this.statement, this.functionDeclaration));
    }

    private static Object permissive(Object object) {
        return object;
    }
}

