/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.javascript.model.ArrayLiteralTree;
import org.sonar.javascript.model.BinaryOperatorTree;
import org.sonar.javascript.model.BlockTree;
import org.sonar.javascript.model.BreakStatementTree;
import org.sonar.javascript.model.CaseClauseTree;
import org.sonar.javascript.model.CatchBlockTree;
import org.sonar.javascript.model.CommaOperatorTree;
import org.sonar.javascript.model.ConditionalOperatorTree;
import org.sonar.javascript.model.ContinueStatementTree;
import org.sonar.javascript.model.DebuggerStatementTree;
import org.sonar.javascript.model.DoWhileStatementTree;
import org.sonar.javascript.model.EmptyStatementTree;
import org.sonar.javascript.model.ExpressionStatementTree;
import org.sonar.javascript.model.ExpressionTree;
import org.sonar.javascript.model.ForInStatementTree;
import org.sonar.javascript.model.ForStatementTree;
import org.sonar.javascript.model.FunctionCallTree;
import org.sonar.javascript.model.FunctionTree;
import org.sonar.javascript.model.IdentifierTree;
import org.sonar.javascript.model.IfStatementTree;
import org.sonar.javascript.model.IndexAccessTree;
import org.sonar.javascript.model.LabelledStatementTree;
import org.sonar.javascript.model.LiteralTree;
import org.sonar.javascript.model.NewOperatorTree;
import org.sonar.javascript.model.ObjectLiteralTree;
import org.sonar.javascript.model.ParenthesizedTree;
import org.sonar.javascript.model.ProgramTree;
import org.sonar.javascript.model.PropertyAccessTree;
import org.sonar.javascript.model.PropertyAssignmentTree;
import org.sonar.javascript.model.ReturnStatementTree;
import org.sonar.javascript.model.SourceElementTree;
import org.sonar.javascript.model.StatementTree;
import org.sonar.javascript.model.SwitchStatementTree;
import org.sonar.javascript.model.ThrowStatementTree;
import org.sonar.javascript.model.Tree;
import org.sonar.javascript.model.TryStatementTree;
import org.sonar.javascript.model.UnaryOperatorTree;
import org.sonar.javascript.model.VariableDeclarationTree;
import org.sonar.javascript.model.VariableStatementTree;
import org.sonar.javascript.model.VisitorsDispatcher;
import org.sonar.javascript.model.WhileStatementTree;
import org.sonar.javascript.model.WithStatementTree;

public abstract class TreeImpl {
    public final AstNode astNode;

    protected TreeImpl(AstNode astNode) {
        this.astNode = astNode;
    }

    public int getLine() {
        return this.astNode.getTokenLine();
    }

    public final <T extends Tree> boolean is(Class<T> cls) {
        return cls.isInstance(this);
    }

    public final <T extends Tree> T as(Class<T> cls) {
        return (T)((Tree)cls.cast(this));
    }

    protected abstract void accept(VisitorsDispatcher var1);

    protected static final void scan(@Nullable List<? extends Tree> trees, VisitorsDispatcher visitors) {
        if (trees != null) {
            for (Tree tree : trees) {
                TreeImpl.scan(tree, visitors);
            }
        }
    }

    protected static final void scan(@Nullable Tree tree, VisitorsDispatcher visitors) {
        if (tree != null) {
            ((TreeImpl)((Object)tree)).accept(visitors);
        }
    }

    public static class FunctionTreeImpl
    extends TreeImpl
    implements FunctionTree {
        private final IdentifierTree identifier;
        private final List<IdentifierTree> formalParameterList;
        private final List<? extends SourceElementTree> body;

        public FunctionTreeImpl(AstNode astNode, @Nullable IdentifierTree identifier, List<IdentifierTree> formalParameterList, List<? extends SourceElementTree> body) {
            super(astNode);
            this.identifier = identifier;
            this.formalParameterList = (List)Preconditions.checkNotNull(formalParameterList);
            this.body = (List)Preconditions.checkNotNull(body);
        }

        @Override
        @Nullable
        public IdentifierTree identifier() {
            return this.identifier;
        }

        @Override
        public List<IdentifierTree> formalParameterList() {
            return this.formalParameterList;
        }

        @Override
        public List<? extends SourceElementTree> body() {
            return this.body;
        }

        @Override
        protected void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, FunctionTree.class);
            FunctionTreeImpl.scan(this.identifier, visitors);
            FunctionTreeImpl.scan(this.formalParameterList, visitors);
            FunctionTreeImpl.scan(this.body, visitors);
            visitors.leave(this, FunctionTree.class);
        }
    }

    public static class ProgramTreeImpl
    extends TreeImpl
    implements ProgramTree {
        private final List<? extends SourceElementTree> sourceElements;

        public ProgramTreeImpl(AstNode astNode, List<? extends SourceElementTree> sourceElements) {
            super(astNode);
            this.sourceElements = (List)Preconditions.checkNotNull(sourceElements);
        }

        @Override
        public List<? extends SourceElementTree> sourceElements() {
            return this.sourceElements;
        }

        @Override
        protected void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, ProgramTree.class);
            ProgramTreeImpl.scan(this.sourceElements, visitors);
            visitors.leave(this, ProgramTree.class);
        }
    }

    public static class CatchBlockTreeImpl
    extends TreeImpl
    implements CatchBlockTree {
        private final IdentifierTree identifier;
        private final BlockTree block;

        public CatchBlockTreeImpl(AstNode astNode, IdentifierTree identifier, BlockTree block) {
            super(astNode);
            this.identifier = (IdentifierTree)Preconditions.checkNotNull((Object)identifier);
            this.block = (BlockTree)Preconditions.checkNotNull((Object)block);
        }

        @Override
        public IdentifierTree identifier() {
            return this.identifier;
        }

        @Override
        public BlockTree block() {
            return this.block;
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, CatchBlockTree.class);
            CatchBlockTreeImpl.scan(this.identifier, visitors);
            CatchBlockTreeImpl.scan(this.block, visitors);
            visitors.leave(this, CatchBlockTree.class);
        }
    }

    public static class TryStatementTreeImpl
    extends TreeImpl
    implements TryStatementTree {
        private final BlockTree block;
        private final CatchBlockTree catchBlock;
        private final BlockTree finallyBlock;

        public TryStatementTreeImpl(AstNode astNode, BlockTree block, @Nullable CatchBlockTree catchBlock, @Nullable BlockTree finallyBlock) {
            super(astNode);
            this.block = (BlockTree)Preconditions.checkNotNull((Object)block);
            this.catchBlock = catchBlock;
            this.finallyBlock = finallyBlock;
        }

        @Override
        public BlockTree block() {
            return this.block;
        }

        @Override
        @Nullable
        public CatchBlockTree catchBlock() {
            return this.catchBlock;
        }

        @Override
        @Nullable
        public BlockTree finallyBlock() {
            return this.finallyBlock;
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, TryStatementTree.class);
            TryStatementTreeImpl.scan(this.block, visitors);
            TryStatementTreeImpl.scan(this.catchBlock, visitors);
            TryStatementTreeImpl.scan(this.finallyBlock, visitors);
            visitors.leave(this, TryStatementTree.class);
        }
    }

    public static class CaseClauseTreeImpl
    extends TreeImpl
    implements CaseClauseTree {
        private final ExpressionTree expression;
        private List<? extends StatementTree> statements;

        public CaseClauseTreeImpl(AstNode astNode, @Nullable ExpressionTree expression, List<? extends StatementTree> statements) {
            super(astNode);
            this.expression = expression;
            this.statements = (List)Preconditions.checkNotNull(statements);
        }

        @Override
        @Nullable
        public ExpressionTree expression() {
            return this.expression;
        }

        @Override
        public List<? extends StatementTree> statements() {
            return this.statements;
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, CaseClauseTree.class);
            CaseClauseTreeImpl.scan(this.expression, visitors);
            CaseClauseTreeImpl.scan(this.statements, visitors);
            visitors.leave(this, CaseClauseTree.class);
        }
    }

    public static class SwitchStatementTreeImpl
    extends TreeImpl
    implements SwitchStatementTree {
        private final ExpressionTree expression;
        private final List<CaseClauseTree> cases;

        public SwitchStatementTreeImpl(AstNode astNode, ExpressionTree expression, List<CaseClauseTree> cases) {
            super(astNode);
            this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
            this.cases = (List)Preconditions.checkNotNull(cases);
        }

        @Override
        public ExpressionTree expression() {
            return this.expression;
        }

        @Override
        public List<CaseClauseTree> cases() {
            return this.cases;
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, SwitchStatementTree.class);
            SwitchStatementTreeImpl.scan(this.expression, visitors);
            SwitchStatementTreeImpl.scan(this.cases, visitors);
            visitors.leave(this, SwitchStatementTree.class);
        }
    }

    public static class WithStatementTreeImpl
    extends TreeImpl
    implements WithStatementTree {
        private final ExpressionTree expression;
        private final StatementTree statement;

        public WithStatementTreeImpl(AstNode astNode, ExpressionTree expression, StatementTree statement) {
            super(astNode);
            this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
            this.statement = (StatementTree)Preconditions.checkNotNull((Object)statement);
        }

        @Override
        public ExpressionTree expression() {
            return this.expression;
        }

        @Override
        public StatementTree statement() {
            return this.statement;
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, WithStatementTree.class);
            WithStatementTreeImpl.scan(this.expression, visitors);
            WithStatementTreeImpl.scan(this.statement, visitors);
            visitors.leave(this, WithStatementTree.class);
        }
    }

    public static class ForInStatementTreeImpl
    extends TreeImpl
    implements ForInStatementTree {
        private final List<VariableDeclarationTree> initVariables;
        private final ExpressionTree leftHandSideExpression;
        private final ExpressionTree expression;
        private final StatementTree statement;

        public ForInStatementTreeImpl(AstNode astNode, List<VariableDeclarationTree> initVariables, ExpressionTree expression, StatementTree statement) {
            super(astNode);
            this.initVariables = (List)Preconditions.checkNotNull(initVariables);
            this.leftHandSideExpression = null;
            this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
            this.statement = (StatementTree)Preconditions.checkNotNull((Object)statement);
        }

        public ForInStatementTreeImpl(AstNode astNode, ExpressionTree leftHandSideExpression, ExpressionTree expression, StatementTree statement) {
            super(astNode);
            this.initVariables = null;
            this.leftHandSideExpression = (ExpressionTree)Preconditions.checkNotNull((Object)leftHandSideExpression);
            this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
            this.statement = (StatementTree)Preconditions.checkNotNull((Object)statement);
        }

        @Override
        @Nullable
        public List<VariableDeclarationTree> initVariables() {
            return this.initVariables;
        }

        @Override
        @Nullable
        public ExpressionTree leftHandSideExpression() {
            return this.leftHandSideExpression;
        }

        @Override
        public ExpressionTree expression() {
            return this.expression;
        }

        @Override
        public StatementTree statement() {
            return this.statement;
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, ForInStatementTree.class);
            ForInStatementTreeImpl.scan(this.initVariables, visitors);
            ForInStatementTreeImpl.scan(this.leftHandSideExpression, visitors);
            ForInStatementTreeImpl.scan(this.expression, visitors);
            ForInStatementTreeImpl.scan(this.statement, visitors);
            visitors.leave(this, ForInStatementTree.class);
        }
    }

    public static class ForStatementTreeImpl
    extends TreeImpl
    implements ForStatementTree {
        private final List<VariableDeclarationTree> initVariables;
        private final ExpressionTree initExpression;
        private final ExpressionTree condition;
        private final ExpressionTree incrementExpression;
        private final StatementTree statement;

        public ForStatementTreeImpl(AstNode astNode, List<VariableDeclarationTree> initVariables, @Nullable ExpressionTree condition, @Nullable ExpressionTree incrementExpression, StatementTree statement) {
            super(astNode);
            this.initExpression = null;
            this.initVariables = (List)Preconditions.checkNotNull(initVariables);
            this.condition = condition;
            this.incrementExpression = incrementExpression;
            this.statement = (StatementTree)Preconditions.checkNotNull((Object)statement);
        }

        public ForStatementTreeImpl(AstNode astNode, @Nullable ExpressionTree initExpression, @Nullable ExpressionTree condition, @Nullable ExpressionTree incrementExpression, StatementTree statement) {
            super(astNode);
            this.initVariables = null;
            this.initExpression = initExpression;
            this.condition = condition;
            this.incrementExpression = incrementExpression;
            this.statement = (StatementTree)Preconditions.checkNotNull((Object)statement);
        }

        @Override
        @Nullable
        public List<VariableDeclarationTree> initVariables() {
            return this.initVariables;
        }

        @Override
        @Nullable
        public ExpressionTree initExpression() {
            return this.initExpression;
        }

        @Override
        @Nullable
        public ExpressionTree condition() {
            return this.condition;
        }

        @Override
        @Nullable
        public ExpressionTree incrementExpression() {
            return this.incrementExpression;
        }

        @Override
        public StatementTree statement() {
            return this.statement;
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, ForStatementTree.class);
            ForStatementTreeImpl.scan(this.initVariables, visitors);
            ForStatementTreeImpl.scan(this.initExpression, visitors);
            ForStatementTreeImpl.scan(this.condition, visitors);
            ForStatementTreeImpl.scan(this.incrementExpression, visitors);
            ForStatementTreeImpl.scan(this.statement, visitors);
            visitors.leave(this, ForStatementTree.class);
        }
    }

    public static class DoWhileStatementTreeImpl
    extends TreeImpl
    implements DoWhileStatementTree {
        private final StatementTree statement;
        private final ExpressionTree condition;

        public DoWhileStatementTreeImpl(AstNode astNode, StatementTree statement, ExpressionTree condition) {
            super(astNode);
            this.statement = (StatementTree)Preconditions.checkNotNull((Object)statement);
            this.condition = (ExpressionTree)Preconditions.checkNotNull((Object)condition);
        }

        @Override
        public StatementTree statement() {
            return this.statement;
        }

        @Override
        public ExpressionTree condition() {
            return this.condition;
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, DoWhileStatementTree.class);
            DoWhileStatementTreeImpl.scan(this.statement, visitors);
            DoWhileStatementTreeImpl.scan(this.condition, visitors);
            visitors.leave(this, DoWhileStatementTree.class);
        }
    }

    public static class WhileStatementTreeImpl
    extends TreeImpl
    implements WhileStatementTree {
        private final ExpressionTree condition;
        private final StatementTree statement;

        public WhileStatementTreeImpl(AstNode astNode, ExpressionTree condition, StatementTree statement) {
            super(astNode);
            this.condition = (ExpressionTree)Preconditions.checkNotNull((Object)condition);
            this.statement = (StatementTree)Preconditions.checkNotNull((Object)statement);
        }

        @Override
        public ExpressionTree condition() {
            return this.condition;
        }

        @Override
        public StatementTree statement() {
            return this.statement;
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, WhileStatementTree.class);
            WhileStatementTreeImpl.scan(this.condition, visitors);
            WhileStatementTreeImpl.scan(this.statement, visitors);
            visitors.leave(this, WhileStatementTree.class);
        }
    }

    public static class ThrowStatementTreeImpl
    extends TreeImpl
    implements ThrowStatementTree {
        private final ExpressionTree expression;

        public ThrowStatementTreeImpl(AstNode astNode, ExpressionTree expression) {
            super(astNode);
            this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
        }

        @Override
        public ExpressionTree expression() {
            return this.expression;
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, ThrowStatementTree.class);
            ThrowStatementTreeImpl.scan(this.expression, visitors);
            visitors.leave(this, ThrowStatementTree.class);
        }
    }

    public static class ReturnStatementTreeImpl
    extends TreeImpl
    implements ReturnStatementTree {
        private final ExpressionTree expression;

        public ReturnStatementTreeImpl(AstNode astNode, @Nullable ExpressionTree expression) {
            super(astNode);
            this.expression = expression;
        }

        @Override
        @Nullable
        public ExpressionTree expression() {
            return this.expression;
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, ReturnStatementTree.class);
            ReturnStatementTreeImpl.scan(this.expression, visitors);
            visitors.leave(this, ReturnStatementTree.class);
        }
    }

    public static class LabelledStatementTreeImpl
    extends TreeImpl
    implements LabelledStatementTree {
        private final IdentifierTree label;
        private final StatementTree statement;

        public LabelledStatementTreeImpl(AstNode astNode, IdentifierTree label, StatementTree statement) {
            super(astNode);
            this.label = (IdentifierTree)Preconditions.checkNotNull((Object)label);
            this.statement = (StatementTree)Preconditions.checkNotNull((Object)statement);
        }

        @Override
        public IdentifierTree label() {
            return this.label;
        }

        @Override
        public StatementTree statement() {
            return this.statement;
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, LabelledStatementTree.class);
            LabelledStatementTreeImpl.scan(this.label, visitors);
            LabelledStatementTreeImpl.scan(this.statement, visitors);
            visitors.leave(this, LabelledStatementTree.class);
        }
    }

    public static class IfStatementTreeImpl
    extends TreeImpl
    implements IfStatementTree {
        private final ExpressionTree condition;
        private final StatementTree thenStatement;
        private final StatementTree elseStatement;

        public IfStatementTreeImpl(AstNode astNode, ExpressionTree condition, StatementTree thenStatement, @Nullable StatementTree elseStatement) {
            super(astNode);
            this.condition = (ExpressionTree)Preconditions.checkNotNull((Object)condition);
            this.thenStatement = (StatementTree)Preconditions.checkNotNull((Object)thenStatement);
            this.elseStatement = elseStatement;
        }

        @Override
        public ExpressionTree condition() {
            return this.condition;
        }

        @Override
        public StatementTree thenStatement() {
            return this.thenStatement;
        }

        @Override
        @Nullable
        public StatementTree elseStatement() {
            return this.elseStatement;
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, IfStatementTree.class);
            IfStatementTreeImpl.scan(this.condition, visitors);
            IfStatementTreeImpl.scan(this.thenStatement, visitors);
            IfStatementTreeImpl.scan(this.elseStatement, visitors);
            visitors.leave(this, IfStatementTree.class);
        }
    }

    public static class ExpressionStatementTreeImpl
    extends TreeImpl
    implements ExpressionStatementTree {
        private final ExpressionTree expression;

        public ExpressionStatementTreeImpl(AstNode astNode, ExpressionTree expression) {
            super(astNode);
            this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
        }

        @Override
        public ExpressionTree expression() {
            return this.expression;
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, ExpressionStatementTree.class);
            ExpressionStatementTreeImpl.scan(this.expression, visitors);
            visitors.leave(this, ExpressionStatementTree.class);
        }
    }

    public static class EmptyStatementTreeImpl
    extends TreeImpl
    implements EmptyStatementTree {
        public EmptyStatementTreeImpl(AstNode astNode) {
            super(astNode);
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, EmptyStatementTree.class);
            visitors.leave(this, EmptyStatementTree.class);
        }
    }

    public static class DebuggerStatementTreeImpl
    extends TreeImpl
    implements DebuggerStatementTree {
        public DebuggerStatementTreeImpl(AstNode astNode) {
            super(astNode);
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, DebuggerStatementTree.class);
            visitors.leave(this, DebuggerStatementTree.class);
        }
    }

    public static class ContinueStatementTreeImpl
    extends TreeImpl
    implements ContinueStatementTree {
        private final IdentifierTree label;

        public ContinueStatementTreeImpl(AstNode astNode, @Nullable IdentifierTree label) {
            super(astNode);
            this.label = label;
        }

        @Override
        @Nullable
        public IdentifierTree label() {
            return this.label;
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, ContinueStatementTree.class);
            ContinueStatementTreeImpl.scan(this.label, visitors);
            visitors.leave(this, ContinueStatementTree.class);
        }
    }

    public static class BreakStatementTreeImpl
    extends TreeImpl
    implements BreakStatementTree {
        private final IdentifierTree label;

        public BreakStatementTreeImpl(AstNode astNode, @Nullable IdentifierTree label) {
            super(astNode);
            this.label = label;
        }

        @Override
        @Nullable
        public IdentifierTree label() {
            return this.label;
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, BreakStatementTree.class);
            BreakStatementTreeImpl.scan(this.label, visitors);
            visitors.leave(this, BreakStatementTree.class);
        }
    }

    public static class VariableDeclarationTreeImpl
    extends TreeImpl
    implements VariableDeclarationTree {
        private final IdentifierTree identifier;
        private final ExpressionTree initialiser;

        public VariableDeclarationTreeImpl(AstNode astNode, IdentifierTree identifier, @Nullable ExpressionTree initialiser) {
            super(astNode);
            this.identifier = (IdentifierTree)Preconditions.checkNotNull((Object)identifier);
            this.initialiser = initialiser;
        }

        @Override
        public IdentifierTree identifier() {
            return this.identifier;
        }

        @Override
        @Nullable
        public ExpressionTree initialiser() {
            return this.initialiser;
        }

        @Override
        protected void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, VariableDeclarationTree.class);
            VariableDeclarationTreeImpl.scan(this.identifier, visitors);
            VariableDeclarationTreeImpl.scan(this.initialiser, visitors);
            visitors.leave(this, VariableDeclarationTree.class);
        }
    }

    public static class VariableStatementTreeImpl
    extends TreeImpl
    implements VariableStatementTree {
        private final List<VariableDeclarationTree> declarations;

        public VariableStatementTreeImpl(AstNode astNode, List<VariableDeclarationTree> declarations) {
            super(astNode);
            this.declarations = (List)Preconditions.checkNotNull(declarations);
        }

        @Override
        public List<VariableDeclarationTree> declarations() {
            return this.declarations;
        }

        @Override
        protected void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, VariableStatementTree.class);
            VariableStatementTreeImpl.scan(this.declarations, visitors);
            visitors.leave(this, VariableStatementTree.class);
        }
    }

    public static class BlockTreeImpl
    extends TreeImpl
    implements BlockTree {
        private final List<? extends StatementTree> statements;

        public BlockTreeImpl(AstNode astNode, List<? extends StatementTree> statements) {
            super(astNode);
            this.statements = (List)Preconditions.checkNotNull(statements);
        }

        @Override
        public List<? extends StatementTree> statements() {
            return this.statements;
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, BlockTree.class);
            BlockTreeImpl.scan(this.statements, visitors);
            visitors.leave(this, BlockTree.class);
        }
    }

    public static class ConditionalOperatorTreeImpl
    extends TreeImpl
    implements ConditionalOperatorTree {
        private final ExpressionTree condition;
        private final ExpressionTree thenExpression;
        private final ExpressionTree elseExpression;

        public ConditionalOperatorTreeImpl(AstNode astNode, ExpressionTree condition, ExpressionTree thenExpression, ExpressionTree elseExpression) {
            super(astNode);
            this.condition = (ExpressionTree)Preconditions.checkNotNull((Object)condition);
            this.thenExpression = (ExpressionTree)Preconditions.checkNotNull((Object)thenExpression);
            this.elseExpression = (ExpressionTree)Preconditions.checkNotNull((Object)elseExpression);
        }

        @Override
        public ExpressionTree condition() {
            return this.condition;
        }

        @Override
        public ExpressionTree thenExpression() {
            return this.thenExpression;
        }

        @Override
        public ExpressionTree elseExpression() {
            return this.elseExpression;
        }

        @Override
        protected void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, ConditionalOperatorTree.class);
            ConditionalOperatorTreeImpl.scan(this.condition, visitors);
            ConditionalOperatorTreeImpl.scan(this.thenExpression, visitors);
            ConditionalOperatorTreeImpl.scan(this.elseExpression, visitors);
            visitors.leave(this, CommaOperatorTree.class);
        }
    }

    public static class CommaOperatorTreeImpl
    extends TreeImpl
    implements CommaOperatorTree {
        private final List<? extends ExpressionTree> expressions;

        public CommaOperatorTreeImpl(AstNode astNode, List<? extends ExpressionTree> expressions) {
            super(astNode);
            this.expressions = (List)Preconditions.checkNotNull(expressions);
        }

        @Override
        public List<? extends ExpressionTree> expressions() {
            return this.expressions;
        }

        @Override
        protected void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, CommaOperatorTree.class);
            CommaOperatorTreeImpl.scan(this.expressions, visitors);
            visitors.leave(this, CommaOperatorTree.class);
        }
    }

    public static class UnaryOperatorTreeImpl
    extends TreeImpl
    implements UnaryOperatorTree {
        private final AstNodeType operator;
        private final ExpressionTree operand;

        public UnaryOperatorTreeImpl(AstNode astNode, AstNodeType operator, ExpressionTree operand) {
            super(astNode);
            this.operator = (AstNodeType)Preconditions.checkNotNull((Object)operator);
            this.operand = (ExpressionTree)Preconditions.checkNotNull((Object)operand);
        }

        @Override
        public AstNodeType operator() {
            return this.operator;
        }

        @Override
        public ExpressionTree operand() {
            return this.operand;
        }

        @Override
        protected void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, BinaryOperatorTree.class);
            UnaryOperatorTreeImpl.scan(this.operand, visitors);
            visitors.leave(this, BinaryOperatorTree.class);
        }
    }

    public static class BinaryOperatorTreeImpl
    extends TreeImpl
    implements BinaryOperatorTree {
        private final int index;
        private final ExpressionTree leftOperand;
        private final ExpressionTree rightOperand;

        public BinaryOperatorTreeImpl(AstNode astNode, int index, ExpressionTree leftOperand, ExpressionTree rightOperand) {
            super(astNode);
            this.index = index;
            this.leftOperand = (ExpressionTree)Preconditions.checkNotNull((Object)leftOperand);
            this.rightOperand = (ExpressionTree)Preconditions.checkNotNull((Object)rightOperand);
        }

        @Override
        public int getLine() {
            return this.astNode.getChild(this.index).getTokenLine();
        }

        @Override
        public ExpressionTree leftOperand() {
            return this.leftOperand;
        }

        @Override
        public AstNodeType operator() {
            return this.astNode.getChild(this.index + 1).getType();
        }

        @Override
        public ExpressionTree rightOperand() {
            return this.rightOperand;
        }

        @Override
        protected void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, BinaryOperatorTree.class);
            BinaryOperatorTreeImpl.scan(this.leftOperand, visitors);
            BinaryOperatorTreeImpl.scan(this.rightOperand, visitors);
            visitors.leave(this, BinaryOperatorTree.class);
        }
    }

    public static class FunctionCallTreeImpl
    extends TreeImpl
    implements FunctionCallTree {
        private final ExpressionTree expression;
        private final List<? extends ExpressionTree> arguments;

        protected FunctionCallTreeImpl(AstNode astNode, ExpressionTree expression, List<? extends ExpressionTree> arguments) {
            super(astNode);
            this.expression = expression;
            this.arguments = arguments;
        }

        @Override
        public ExpressionTree expression() {
            return this.expression;
        }

        @Override
        public List<? extends ExpressionTree> arguments() {
            return this.arguments;
        }

        @Override
        protected void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, FunctionCallTree.class);
            FunctionCallTreeImpl.scan(this.expression, visitors);
            FunctionCallTreeImpl.scan(this.arguments, visitors);
            visitors.leave(this, FunctionCallTree.class);
        }
    }

    public static class NewOperatorTreeImpl
    extends TreeImpl
    implements NewOperatorTree {
        private final ExpressionTree constructor;
        private final List<? extends ExpressionTree> arguments;

        protected NewOperatorTreeImpl(AstNode astNode, ExpressionTree constructor, List<? extends ExpressionTree> arguments) {
            super(astNode);
            this.constructor = constructor;
            this.arguments = arguments;
        }

        @Override
        public ExpressionTree constructor() {
            return this.constructor;
        }

        @Override
        public List<? extends ExpressionTree> arguments() {
            return this.arguments;
        }

        @Override
        protected void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, NewOperatorTree.class);
            NewOperatorTreeImpl.scan(this.constructor, visitors);
            NewOperatorTreeImpl.scan(this.arguments, visitors);
            visitors.leave(this, NewOperatorTree.class);
        }
    }

    public static class PropertyAccessTreeImpl
    extends TreeImpl
    implements PropertyAccessTree {
        private final ExpressionTree expression;
        private final IdentifierTree identifier;

        protected PropertyAccessTreeImpl(AstNode astNode, ExpressionTree expression, IdentifierTree identifier) {
            super(astNode);
            this.expression = expression;
            this.identifier = identifier;
        }

        @Override
        public ExpressionTree expression() {
            return this.expression;
        }

        @Override
        public IdentifierTree identifier() {
            return this.identifier;
        }

        @Override
        protected void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, PropertyAccessTree.class);
            PropertyAccessTreeImpl.scan(this.expression, visitors);
            PropertyAccessTreeImpl.scan(this.identifier, visitors);
            visitors.leave(this, PropertyAccessTree.class);
        }
    }

    public static class IndexAccessTreeImpl
    extends TreeImpl
    implements IndexAccessTree {
        private final ExpressionTree expression;
        private final ExpressionTree index;

        protected IndexAccessTreeImpl(AstNode astNode, ExpressionTree expression, ExpressionTree index) {
            super(astNode);
            this.expression = expression;
            this.index = index;
        }

        @Override
        public ExpressionTree expression() {
            return this.expression;
        }

        @Override
        public ExpressionTree index() {
            return this.index;
        }

        @Override
        protected void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, IndexAccessTree.class);
            IndexAccessTreeImpl.scan(this.expression, visitors);
            IndexAccessTreeImpl.scan(this.index, visitors);
            visitors.leave(this, IndexAccessTree.class);
        }
    }

    public static class PropertyAssignmentTreeImpl
    extends TreeImpl
    implements PropertyAssignmentTree {
        private final Tree propertyName;
        private final ExpressionTree expression;
        private final List<IdentifierTree> propertySetParameters;
        private final List<? extends SourceElementTree> body;

        protected PropertyAssignmentTreeImpl(AstNode astNode, Tree propertyName, @Nullable ExpressionTree expression, @Nullable List<IdentifierTree> propertySetParameters, @Nullable List<? extends SourceElementTree> body) {
            super(astNode);
            this.propertyName = (Tree)Preconditions.checkNotNull((Object)propertyName);
            this.expression = expression;
            this.propertySetParameters = propertySetParameters;
            this.body = body;
        }

        @Override
        public Tree propertyName() {
            return this.propertyName;
        }

        @Override
        @Nullable
        public ExpressionTree expression() {
            return this.expression;
        }

        @Override
        @Nullable
        public List<IdentifierTree> propertySetParameters() {
            return this.propertySetParameters;
        }

        @Override
        @Nullable
        public List<? extends SourceElementTree> body() {
            return this.body;
        }

        @Override
        protected void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, PropertyAssignmentTree.class);
            PropertyAssignmentTreeImpl.scan(this.propertyName, visitors);
            PropertyAssignmentTreeImpl.scan(this.expression, visitors);
            PropertyAssignmentTreeImpl.scan(this.propertySetParameters, visitors);
            PropertyAssignmentTreeImpl.scan(this.body, visitors);
            visitors.leave(this, PropertyAssignmentTree.class);
        }
    }

    public static class ObjectLiteralTreeImpl
    extends TreeImpl
    implements ObjectLiteralTree {
        private final List<PropertyAssignmentTree> propertyAssignments;

        protected ObjectLiteralTreeImpl(AstNode astNode, List<PropertyAssignmentTree> propertyAssignments) {
            super(astNode);
            this.propertyAssignments = (List)Preconditions.checkNotNull(propertyAssignments);
        }

        @Override
        public List<PropertyAssignmentTree> propertyAssignments() {
            return this.propertyAssignments;
        }

        @Override
        protected void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, ObjectLiteralTree.class);
            ObjectLiteralTreeImpl.scan(this.propertyAssignments, visitors);
            visitors.leave(this, ObjectLiteralTree.class);
        }
    }

    public static class ArrayLiteralTreeImpl
    extends TreeImpl
    implements ArrayLiteralTree {
        private final List<? extends ExpressionTree> expressions;

        protected ArrayLiteralTreeImpl(AstNode astNode, List<? extends ExpressionTree> expressions) {
            super(astNode);
            this.expressions = (List)Preconditions.checkNotNull(expressions);
        }

        @Override
        public List<? extends ExpressionTree> expressions() {
            return this.expressions;
        }

        @Override
        protected void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, ArrayLiteralTree.class);
            ArrayLiteralTreeImpl.scan(this.expressions, visitors);
            visitors.leave(this, ArrayLiteralTree.class);
        }
    }

    public static class ParenthesizedTreeImpl
    extends TreeImpl
    implements ParenthesizedTree {
        private final ExpressionTree expression;

        public ParenthesizedTreeImpl(AstNode astNode, ExpressionTree expression) {
            super(astNode);
            this.expression = (ExpressionTree)Preconditions.checkNotNull((Object)expression);
        }

        @Override
        public ExpressionTree expression() {
            return this.expression;
        }

        @Override
        protected void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, ParenthesizedTree.class);
            ParenthesizedTreeImpl.scan(this.expression, visitors);
            visitors.leave(this, ParenthesizedTree.class);
        }
    }

    public static class LiteralTreeImpl
    extends TreeImpl
    implements LiteralTree {
        protected LiteralTreeImpl(AstNode astNode) {
            super(astNode);
        }

        @Override
        protected void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, LiteralTree.class);
            visitors.leave(this, LiteralTree.class);
        }
    }

    public static class IdentifierTreeImpl
    extends TreeImpl
    implements IdentifierTree {
        private final String name;

        public IdentifierTreeImpl(AstNode astNode, String name) {
            super(astNode);
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public void accept(VisitorsDispatcher visitors) {
            visitors.visit(this, IdentifierTree.class);
            visitors.leave(this, IdentifierTree.class);
        }
    }
}

