/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.metrics;

import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.File;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.javascript.api.EcmaScriptMetric;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.measures.MetricDef;
import org.sonar.sslr.parser.LexerlessGrammar;

public class FileLinesVisitor
extends SquidAstVisitor<LexerlessGrammar>
implements AstAndTokenVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(FileLinesVisitor.class);
    private final FileLinesContextFactory fileLinesContextFactory;
    private final FileSystem fileSystem;
    private final PathResolver pathResolver;
    private final Set<Integer> linesOfCode = Sets.newHashSet();
    private final Set<Integer> linesOfComments = Sets.newHashSet();

    public FileLinesVisitor(FileLinesContextFactory fileLinesContextFactory, FileSystem fileSystem, PathResolver pathResolver) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.fileSystem = fileSystem;
        this.pathResolver = pathResolver;
    }

    public void visitToken(Token token) {
        if (token.getType().equals(GenericTokenType.EOF)) {
            return;
        }
        this.linesOfCode.add(token.getLine());
        List trivias = token.getTrivia();
        for (Trivia trivia : trivias) {
            if (!trivia.isComment()) continue;
            this.linesOfComments.add(trivia.getToken().getLine());
        }
    }

    public void leaveFile(AstNode astNode) {
        FileLinesContext fileLinesContext = this.fileLinesContextFactory.createFor((Resource)File.create((String)this.pathResolver.relativePath(this.fileSystem.baseDir(), this.getContext().getFile().getAbsoluteFile())));
        if (fileLinesContext != null) {
            int fileLength = this.getContext().peekSourceCode().getInt((MetricDef)EcmaScriptMetric.LINES);
            for (int line = 1; line <= fileLength; ++line) {
                fileLinesContext.setIntValue("ncloc_data", line, this.linesOfCode.contains(line) ? 1 : 0);
                fileLinesContext.setIntValue("comment_lines_data", line, this.linesOfComments.contains(line) ? 1 : 0);
            }
            fileLinesContext.save();
        } else {
            LOG.warn("Cannot save measures for DevCockpit for file {}. Unable to retrieve the associated sonar resource.", (Object)this.getContext().getFile().getName());
        }
        this.linesOfCode.clear();
        this.linesOfComments.clear();
    }
}

