/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.statement;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;
import org.sonar.javascript.model.interfaces.statement.ContinueStatementTree;

public class ContinueStatementTreeImpl
extends JavaScriptTree
implements ContinueStatementTree {
    private SyntaxToken continueKeyword;
    @Nullable
    private final IdentifierTree label;

    public ContinueStatementTreeImpl(AstNode eos) {
        super(Tree.Kind.CONTINUE_STATEMENT);
        this.label = null;
        this.addChild(eos);
    }

    public ContinueStatementTreeImpl(IdentifierTree label, AstNode eos) {
        super(Tree.Kind.CONTINUE_STATEMENT);
        this.label = label;
        this.addChild((AstNode)label);
        this.addChild(eos);
    }

    public ContinueStatementTreeImpl complete(InternalSyntaxToken continueKeyword) {
        Preconditions.checkState((this.continueKeyword == null ? 1 : 0) != 0, (Object)"Already completed");
        this.continueKeyword = continueKeyword;
        this.prependChildren(continueKeyword);
        return this;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.CONTINUE_STATEMENT;
    }

    @Override
    public SyntaxToken continueKeyword() {
        return this.continueKeyword;
    }

    @Override
    @Nullable
    public IdentifierTree label() {
        return this.label;
    }

    @Override
    public Tree endOfStatement() {
        throw new UnsupportedOperationException("Not supported yet in the strongly typed AST.");
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.singletonIterator((Object)this.label);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitContinueStatement(this);
    }
}

