/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.ast.resolve;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.javascript.ast.resolve.SymbolDeclaration;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;

public class Symbol {
    private final String name;
    private List<SymbolDeclaration> declarations = Lists.newArrayList();
    private Kind kind;
    private boolean buildIn;

    public Symbol(String name, SymbolDeclaration declaration, Kind kind) {
        this.name = name;
        this.kind = kind;
        this.declarations.add(declaration);
        this.buildIn = false;
    }

    public Symbol(String name, SymbolDeclaration declaration, Kind kind, boolean buildIn) {
        this.name = name;
        this.kind = kind;
        this.declarations.add(declaration);
        this.buildIn = buildIn;
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public InternalSyntaxToken getSymbolNameToken() {
        SymbolDeclaration firstDeclaration = this.getFirstDeclaration();
        if (firstDeclaration.is(SymbolDeclaration.Kind.BUILD_IN)) {
            return null;
        }
        return (InternalSyntaxToken)((IdentifierTree)firstDeclaration.tree()).identifierToken();
    }

    public Kind kind() {
        return this.kind;
    }

    public boolean buildIn() {
        return this.buildIn;
    }

    public boolean is(Kind kind) {
        return kind.equals((Object)this.kind);
    }

    public List<SymbolDeclaration> declarations() {
        return this.declarations;
    }

    public SymbolDeclaration getFirstDeclaration() {
        return this.declarations.get(0);
    }

    public static enum Kind {
        VARIABLE("variable"),
        FUNCTION("function"),
        PARAMETER("parameter"),
        CLASS("class");

        private final String value;

        private Kind(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

