/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.ast.resolve;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.ArrayUtils;
import org.sonar.api.source.Symbolizable;
import org.sonar.javascript.ast.resolve.Scope;
import org.sonar.javascript.ast.resolve.Symbol;
import org.sonar.javascript.ast.resolve.SymbolVisitor;
import org.sonar.javascript.ast.resolve.Usage;
import org.sonar.javascript.highlighter.SourceFileOffsets;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.ScriptTree;

public class SymbolModel {
    private Map<Tree, Scope> scopes = Maps.newHashMap();
    private Map<Symbol, Scope> symbolScope = Maps.newHashMap();
    private Multimap<Symbol, Usage> usagesTree = HashMultimap.create();
    private Map<Usage, Symbol> refersTo = Maps.newHashMap();

    public static SymbolModel createFor(ScriptTree script, @Nullable Symbolizable symbolizable, @Nullable SourceFileOffsets sourceFileOffsets) {
        SymbolModel symbolModel = new SymbolModel();
        new SymbolVisitor(symbolModel, symbolizable, sourceFileOffsets).visitScript(script);
        return symbolModel;
    }

    public void setScopeFor(Tree tree, Scope scope) {
        this.scopes.put(tree, scope);
    }

    public Scope getScopeFor(Tree tree) {
        return this.scopes.get(tree);
    }

    public void setScopeForSymbol(Symbol symbol, Scope scope) {
        this.symbolScope.put(symbol, scope);
    }

    public Collection<Usage> getUsageFor(Symbol symbol) {
        return this.usagesTree.get((Object)symbol);
    }

    public void addUsage(Symbol symbol, Usage usage) {
        this.usagesTree.put((Object)symbol, (Object)usage);
        this.refersTo.put(usage, symbol);
    }

    public List<Symbol> getSymbols(Symbol.Kind ... kinds) {
        Set<Symbol> symbols = this.symbolScope.keySet();
        if (kinds.length == 0) {
            return Lists.newArrayList(symbols);
        }
        LinkedList<Symbol> result = new LinkedList<Symbol>();
        for (Symbol symbol : symbols) {
            if (!ArrayUtils.contains((Object[])kinds, (Object)((Object)symbol.kind()))) continue;
            result.add(symbol);
        }
        return result;
    }

    public List<Symbol> getSymbols(List<String> names) {
        Set<Symbol> symbols = this.symbolScope.keySet();
        if (names.isEmpty()) {
            return Lists.newArrayList(symbols);
        }
        LinkedList<Symbol> result = new LinkedList<Symbol>();
        for (Symbol symbol : symbols) {
            if (!names.contains(symbol.name())) continue;
            result.add(symbol);
        }
        return result;
    }

    public List<Symbol> getSymbols(String name) {
        return this.getSymbols((List<String>)ImmutableList.of((Object)name));
    }

    public Collection<Scope> getScopes() {
        Collection<Scope> duplicatedScopes = this.symbolScope.values();
        HashSet<Scope> uniqueScopes = new HashSet<Scope>();
        for (Scope scope : duplicatedScopes) {
            uniqueScopes.add(scope);
        }
        return uniqueScopes;
    }

    public Scope getScopeFor(Symbol symbol) {
        return this.symbolScope.get(symbol);
    }
}

