/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.ast.resolve;

import javax.annotation.Nullable;
import org.sonar.javascript.ast.resolve.Symbol;
import org.sonar.javascript.ast.resolve.SymbolModel;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;

public class Usage {
    private Kind kind;
    private IdentifierTree symbolTree;
    private Tree usageTree;
    private boolean init = false;

    private Usage(IdentifierTree symbolTree, @Nullable Tree usageTree, Kind kind) {
        this.kind = kind;
        this.symbolTree = symbolTree;
        this.usageTree = usageTree != null ? usageTree : symbolTree;
    }

    public Kind kind() {
        return this.kind;
    }

    public IdentifierTree symbolTree() {
        return this.symbolTree;
    }

    public Tree usageTree() {
        return this.usageTree;
    }

    public boolean isInit() {
        return this.init;
    }

    public static Usage create(SymbolModel symbolModel, Symbol symbol, IdentifierTree symbolTree, Tree usageTree, Kind kind) {
        Usage usage = new Usage(symbolTree, usageTree, kind);
        symbolModel.addUsage(symbol, usage);
        return usage;
    }

    public static Usage create(SymbolModel symbolModel, Symbol symbol, IdentifierTree symbolTree, Kind kind) {
        Usage usage = new Usage(symbolTree, null, kind);
        symbolModel.addUsage(symbol, usage);
        return usage;
    }

    public static Usage createInit(SymbolModel symbolModel, Symbol symbol, IdentifierTree symbolTree, Tree usageTree, Kind kind) {
        Usage usage = Usage.create(symbolModel, symbol, symbolTree, usageTree, kind);
        usage.init = true;
        return usage;
    }

    public String toString() {
        return "Usage{kind=" + (Object)((Object)this.kind) + ", symbolTree=" + this.symbolTree + ", init=" + this.init + '}';
    }

    public static enum Kind {
        WRITE,
        READ,
        READ_WRITE;

    }
}

