/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.ast.visitors;

import com.google.common.base.Preconditions;
import java.io.File;
import org.sonar.api.config.Settings;
import org.sonar.javascript.ast.resolve.SymbolModel;
import org.sonar.javascript.ast.visitors.AstTreeVisitorContext;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.ScriptTree;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.CodeVisitor;
import org.sonar.squidbridge.api.SourceFile;

public class AstTreeVisitorContextImpl
implements AstTreeVisitorContext {
    private final ScriptTree tree;
    private final SourceFile sourceFile;
    private final File file;
    private final SymbolModel symbolModel;
    private final Settings settings;

    public AstTreeVisitorContextImpl(ScriptTree tree, SourceFile sourceFile, File file, SymbolModel symbolModel, Settings settings) {
        this.tree = tree;
        this.sourceFile = sourceFile;
        this.file = file;
        this.symbolModel = symbolModel;
        this.settings = settings;
    }

    @Override
    public ScriptTree getTree() {
        return this.tree;
    }

    @Override
    public void addIssue(CodeVisitor check, Tree tree, String message) {
        this.commonAddIssue(check, this.getLine(tree), message, -1.0);
    }

    @Override
    public void addIssue(CodeVisitor check, int line, String message) {
        this.commonAddIssue(check, line, message, -1.0);
    }

    @Override
    public void addIssue(CodeVisitor check, Tree tree, String message, double cost) {
        this.commonAddIssue(check, this.getLine(tree), message, cost);
    }

    @Override
    public void addIssue(CodeVisitor check, int line, String message, double cost) {
        this.commonAddIssue(check, line, message, cost);
    }

    @Override
    public String getFileKey() {
        return this.sourceFile.getKey();
    }

    @Override
    public File getFile() {
        return this.file;
    }

    private void commonAddIssue(CodeVisitor check, int line, String message, double cost) {
        Preconditions.checkNotNull((Object)check);
        Preconditions.checkNotNull((Object)message);
        CheckMessage checkMessage = new CheckMessage((Object)check, message, new Object[0]);
        if (cost > 0.0) {
            checkMessage.setCost(cost);
        }
        if (line > 0) {
            checkMessage.setLine(line);
        }
        this.sourceFile.log(checkMessage);
    }

    private int getLine(Tree tree) {
        return ((JavaScriptTree)tree).getLine();
    }

    @Override
    public SymbolModel getSymbolModel() {
        return this.symbolModel;
    }

    @Override
    public String[] getPropertyValues(String name) {
        return this.settings.getStringArray(name);
    }
}

