/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.highlighter;

import org.sonar.api.source.Symbolizable;
import org.sonar.javascript.ast.resolve.Symbol;
import org.sonar.javascript.ast.resolve.SymbolModel;
import org.sonar.javascript.ast.resolve.Usage;
import org.sonar.javascript.highlighter.SourceFileOffsets;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;

public class HighlightSymbolTableBuilder {
    private HighlightSymbolTableBuilder() {
    }

    public static Symbolizable.SymbolTable build(Symbolizable symbolizable, SymbolModel symbolModel, SourceFileOffsets sourceFileOffsets) {
        Symbolizable.SymbolTableBuilder builder = symbolizable.newSymbolTableBuilder();
        for (Symbol symbol : symbolModel.getSymbols(new Symbol.Kind[0])) {
            InternalSyntaxToken token = symbol.getSymbolNameToken();
            if (symbol.buildIn() || token == null) continue;
            int startOffset = sourceFileOffsets.startOffset(token.getToken());
            int endOffset = sourceFileOffsets.endOffset(token.getToken());
            org.sonar.api.source.Symbol reference = builder.newSymbol(startOffset, endOffset);
            for (Usage usage : symbolModel.getUsageFor(symbol)) {
                if (usage.isInit()) continue;
                builder.newReference(reference, sourceFileOffsets.startOffset(((InternalSyntaxToken)usage.symbolTree().identifierToken()).getToken()));
            }
        }
        return builder.build();
    }
}

