/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.expression;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ParenthesisedExpressionTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;

public class ParenthesisedExpressionTreeImpl
extends JavaScriptTree
implements ParenthesisedExpressionTree {
    private final InternalSyntaxToken openParenthesis;
    private final ExpressionTree expression;
    private final InternalSyntaxToken closeParenthesis;

    public ParenthesisedExpressionTreeImpl(InternalSyntaxToken openParenthesis, ExpressionTree expression, InternalSyntaxToken closeParenthesis) {
        super(Tree.Kind.PARENTHESISED_EXPRESSION);
        this.openParenthesis = openParenthesis;
        this.expression = expression;
        this.closeParenthesis = closeParenthesis;
        this.addChildren(openParenthesis, (AstNode)expression, closeParenthesis);
    }

    @Override
    public SyntaxToken openParenthesis() {
        return this.openParenthesis;
    }

    @Override
    public ExpressionTree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken closeParenthesis() {
        return this.closeParenthesis;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.PARENTHESISED_EXPRESSION;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.singletonIterator((Object)this.expression);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitParenthesisedExpression(this);
    }
}

