/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.statement;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.implementations.statement.ElseClauseTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;
import org.sonar.javascript.model.interfaces.statement.ElseClauseTree;
import org.sonar.javascript.model.interfaces.statement.IfStatementTree;
import org.sonar.javascript.model.interfaces.statement.StatementTree;

public class IfStatementTreeImpl
extends JavaScriptTree
implements IfStatementTree {
    private final SyntaxToken ifKeyword;
    private final SyntaxToken openParenthesis;
    private final ExpressionTree condition;
    private final SyntaxToken closeParenthesis;
    private final ElseClauseTree elseClause;
    private final StatementTree statement;

    public IfStatementTreeImpl(InternalSyntaxToken ifKeyword, InternalSyntaxToken openParenthesis, ExpressionTree condition, InternalSyntaxToken closeParenthesis, StatementTree statement) {
        super(Tree.Kind.IF_STATEMENT);
        this.ifKeyword = ifKeyword;
        this.openParenthesis = openParenthesis;
        this.condition = condition;
        this.closeParenthesis = closeParenthesis;
        this.elseClause = null;
        this.statement = statement;
        this.addChildren(ifKeyword, openParenthesis, (AstNode)condition, closeParenthesis, (AstNode)statement);
    }

    public IfStatementTreeImpl(InternalSyntaxToken ifKeyword, InternalSyntaxToken openParenthesis, ExpressionTree condition, InternalSyntaxToken closeParenthesis, StatementTree statement, ElseClauseTreeImpl elseClause) {
        super(Tree.Kind.IF_STATEMENT);
        this.ifKeyword = ifKeyword;
        this.openParenthesis = openParenthesis;
        this.condition = condition;
        this.closeParenthesis = closeParenthesis;
        this.elseClause = elseClause;
        this.statement = statement;
        this.addChildren(ifKeyword, openParenthesis, (AstNode)condition, closeParenthesis, (AstNode)statement, elseClause);
    }

    @Override
    public SyntaxToken ifKeyword() {
        return this.ifKeyword;
    }

    @Override
    public SyntaxToken openParenthesis() {
        return this.openParenthesis;
    }

    @Override
    public ExpressionTree condition() {
        return this.condition;
    }

    @Override
    public SyntaxToken closeParenthesis() {
        return this.closeParenthesis;
    }

    @Override
    public StatementTree statement() {
        return this.statement;
    }

    @Override
    @Nullable
    public ElseClauseTree elseClause() {
        return this.elseClause;
    }

    public boolean hasElse() {
        return this.elseClause != null;
    }

    @Override
    public AstNodeType getKind() {
        return Tree.Kind.IF_STATEMENT;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        if (this.hasElse()) {
            return Iterators.forArray((Object[])new Tree[]{this.condition, this.elseClause, this.statement});
        }
        return Iterators.forArray((Object[])new Tree[]{this.condition, this.statement});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitIfStatement(this);
    }
}

