/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.parser;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.TokenType;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;
import org.sonar.sslr.parser.LexerlessGrammar;

public enum EcmaScriptGrammar implements GrammarRuleKey
{
    EOF,
    EOS,
    EOS_NO_LB,
    IDENTIFIER_NAME,
    LITERAL,
    NULL_LITERAL,
    BOOLEAN_LITERAL,
    STRING_LITERAL,
    TEMPLATE_SPANS,
    TEMPLATE_CHARACTER,
    LINE_CONTINUATION,
    BACKTICK,
    DOLLAR_SIGN,
    BACKSLASH,
    IDENTIFIER_NO_LB,
    KEYWORD,
    LETTER_OR_DIGIT,
    SPACING_NO_LINE_BREAK_NOT_FOLLOWED_BY_LINE_BREAK,
    SPACING,
    SPACING_NOT_SKIPPED,
    SPACING_NO_LB,
    NEXT_NOT_LB,
    LINE_TERMINATOR_SEQUENCE,
    PRIMARY_EXPRESSION,
    PROPERTY_DEFINITION,
    PROPERTY_NAME,
    MEMBER_EXPRESSION,
    ARGUMENTS_LIST,
    LEFT_HAND_SIDE_EXPRESSION,
    POSTFIX_EXPRESSION,
    UNARY_EXPRESSION,
    MULTIPLICATIVE_EXPRESSION,
    ADDITIVE_EXPRESSION,
    SHIFT_EXPRESSION,
    RELATIONAL_EXPRESSION,
    EQUALITY_EXPRESSION,
    BITWISE_AND_EXPRESSION,
    BITWISE_XOR_EXPRESSION,
    BITWISE_OR_EXPRESSION,
    LOGICAL_AND_EXPRESSION,
    LOGICAL_OR_EXPRESSION,
    ASSIGNMENT_EXPRESSION,
    ASSIGNMENT_EXPRESSION_NO_IN,
    ASSIGNMENT_OPERATOR,
    EXPRESSION,
    EXPRESSION_NO_LB,
    EXPRESSION_NO_IN,
    ARROW_FUNCTION,
    GENERATOR_EXPRESSION,
    ARRAY_LITERAL_ELEMENT,
    SPREAD_ELEMENT,
    ELEMENT_LIST,
    BINDING_REST_ELEMENT,
    SINGLE_NAME_BINDING,
    BINDING_ELEMENT,
    BINDING_PROPERTY,
    ARRAY_BINDING_PATTERN,
    BINDING_PATTERN,
    STATEMENT,
    VARIABLE_DECLARATION,
    INITIALISER,
    ITERATION_STATEMENT,
    OF,
    RETURN_STATEMENT,
    WITH_STATEMENT,
    FINALLY,
    FUNCTION_DECLARATION,
    FUNCTION_EXPRESSION,
    FORMAL_PARAMETER,
    LET,
    IDENTIFIER_REFERENCE,
    BINDING_IDENTIFIER,
    CLASS_ELEMENT,
    METHOD_DEFINITION,
    STATIC,
    GET,
    SET,
    MODULE_BODY,
    IMPORT_DECLARATION,
    EXPORT_DECLARATION,
    FROM,
    AS,
    SCRIPT,
    SCRIPT_BODY,
    SHEBANG,
    NEXT_NOT_LET,
    NEXT_NOT_LCURLY_AND_FUNCTION,
    NEXT_NOT_LCURLY,
    NEXT_NOT_LET_AND_BRACKET,
    NEXT_NOT_ES6_ASSIGNMENT_EXPRESSION,
    NEXT_NOT_FUNCTION_AND_CLASS;

    private final String internalName;

    public static LexerlessGrammar createGrammar() {
        return EcmaScriptGrammar.createGrammarBuilder().build();
    }

    public static LexerlessGrammarBuilder createGrammarBuilder() {
        LexerlessGrammarBuilder b = LexerlessGrammarBuilder.create();
        b.rule((GrammarRuleKey)IDENTIFIER_NAME).is((Object)SPACING, new Object[]{b.regexp("(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])*+")});
        EcmaScriptGrammar.lexical(b);
        b.setRootRule((GrammarRuleKey)SCRIPT);
        return b;
    }

    private static void lexical(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)SPACING_NO_LINE_BREAK_NOT_FOLLOWED_BY_LINE_BREAK).is((Object)SPACING_NO_LB, new Object[]{NEXT_NOT_LB});
        b.rule((GrammarRuleKey)SPACING).is(b.skippedTrivia(b.regexp("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+")), new Object[]{b.zeroOrMore(b.commentTrivia(b.regexp("(?://[^\\n\\r]*+|<!--[^\\n\\r]*+|/\\*[\\s\\S]*?\\*/)")), new Object[]{b.skippedTrivia(b.regexp("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+"))})}).skip();
        b.rule((GrammarRuleKey)SPACING_NOT_SKIPPED).is((Object)SPACING);
        b.rule((GrammarRuleKey)SPACING_NO_LB).is(b.zeroOrMore(b.firstOf(b.skippedTrivia(b.regexp("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]++")), b.commentTrivia(b.regexp("(?://[^\\n\\r]*+|<!--[^\\n\\r]*+|/\\*[^\\n\\r]*?\\*/)"))))).skip();
        b.rule((GrammarRuleKey)NEXT_NOT_LB).is(b.nextNot(b.regexp("(?:/\\*[\\s\\S]*?\\*/|[\\n\\r\\u2028\\u2029])"))).skip();
        b.rule((GrammarRuleKey)LINE_TERMINATOR_SEQUENCE).is(b.skippedTrivia(b.regexp("(?:\\n|\\r\\n|\\r|\\u2028|\\u2029)"))).skip();
        b.rule((GrammarRuleKey)EOS).is(b.firstOf(b.sequence((Object)SPACING, (Object)EcmaScriptPunctuator.SEMI), b.sequence((Object)SPACING_NO_LB, (Object)LINE_TERMINATOR_SEQUENCE), new Object[]{b.sequence((Object)SPACING_NO_LB, b.next((Object)"}")), b.sequence((Object)SPACING, b.endOfInput())}));
        b.rule((GrammarRuleKey)EOS_NO_LB).is(b.firstOf(b.sequence((Object)SPACING_NO_LB, (Object)NEXT_NOT_LB, new Object[]{EcmaScriptPunctuator.SEMI}), b.sequence((Object)SPACING_NO_LB, (Object)LINE_TERMINATOR_SEQUENCE), new Object[]{b.sequence((Object)SPACING_NO_LB, b.next((Object)"}")), b.sequence((Object)SPACING_NO_LB, b.endOfInput())}));
        b.rule((GrammarRuleKey)EOF).is(b.token((TokenType)GenericTokenType.EOF, b.endOfInput())).skip();
        b.rule((GrammarRuleKey)EcmaScriptTokenType.IDENTIFIER).is((Object)SPACING, new Object[]{b.nextNot((Object)KEYWORD), b.regexp("(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])*+")});
        b.rule((GrammarRuleKey)IDENTIFIER_NO_LB).is((Object)SPACING_NO_LB, new Object[]{NEXT_NOT_LB, Tree.Kind.LABEL_IDENTIFIER}).skip();
        b.rule((GrammarRuleKey)EcmaScriptTokenType.NUMERIC_LITERAL).is((Object)SPACING, new Object[]{b.regexp("(?:[0-9]++\\.([0-9]++)?+([Ee][+-]?+[0-9_]++)?+[fFdD]?+|\\.[0-9]++([Ee][+-]?+[0-9_]++)?+[fFdD]?+|[0-9]++[fFdD]|[0-9]++([Ee][+-]?+[0-9_]++)[fFdD]?+|0[xX][0-9a-fA-F]++\\.[0-9a-fA-F_]*+([Pp][+-]?+[0-9_]++)?+[fFdD]?+|0[xX][0-9a-fA-F]++([Pp][+-]?+[0-9_]++)[fFdD]?+|0[xX][0-9a-fA-F]++[lL]?+|0[bB][01]++[lL]?+|[0-9]++[lL]?+)")});
        b.rule((GrammarRuleKey)STRING_LITERAL).is((Object)SPACING, new Object[]{b.token((TokenType)GenericTokenType.LITERAL, b.regexp("(?:\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\"|'([^'\\\\]*+(\\\\[\\s\\S])?+)*+')"))});
        b.rule((GrammarRuleKey)EcmaScriptTokenType.REGULAR_EXPRESSION_LITERAL).is((Object)SPACING, new Object[]{b.regexp("\\/(?![*/])(?:[^\\\\\\[/&&[^\\r\\n\\u2028\\u2029]]|\\[(?:[^\\]\\\\&&[^\\r\\n\\u2028\\u2029]]|\\\\[^\\r\\n\\u2028\\u2029])*+\\]|\\\\[^\\r\\n\\u2028\\u2029])*+\\/\\p{javaJavaIdentifierPart}*+")});
        b.rule((GrammarRuleKey)TEMPLATE_CHARACTER).is(b.firstOf(b.sequence((Object)DOLLAR_SIGN, b.nextNot((Object)EcmaScriptPunctuator.LCURLYBRACE)), b.sequence((Object)BACKSLASH, (Object)"\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}"), new Object[]{LINE_CONTINUATION, LINE_TERMINATOR_SEQUENCE, b.regexp("[^`\\$\\n\\r\\u2028\\u2029]")}));
        b.rule((GrammarRuleKey)LINE_CONTINUATION).is((Object)BACKSLASH, new Object[]{LINE_TERMINATOR_SEQUENCE});
        b.rule((GrammarRuleKey)BACKSLASH).is(EcmaScriptGrammar.character(b, "\\"));
        b.rule((GrammarRuleKey)BACKTICK).is(EcmaScriptGrammar.character(b, "`"));
        b.rule((GrammarRuleKey)DOLLAR_SIGN).is(EcmaScriptGrammar.character(b, "$"));
        b.rule((GrammarRuleKey)OF).is(EcmaScriptGrammar.word(b, "of"));
        b.rule((GrammarRuleKey)FROM).is(EcmaScriptGrammar.word(b, "from"));
        b.rule((GrammarRuleKey)AS).is(EcmaScriptGrammar.word(b, "as"));
        b.rule((GrammarRuleKey)LET).is(EcmaScriptGrammar.word(b, "let"));
        b.rule((GrammarRuleKey)STATIC).is(EcmaScriptGrammar.word(b, "static"));
        b.rule((GrammarRuleKey)SET).is(EcmaScriptGrammar.word(b, "set"));
        b.rule((GrammarRuleKey)GET).is(EcmaScriptGrammar.word(b, "get"));
        b.rule((GrammarRuleKey)SHEBANG).is(b.regexp("#![^\\n\\r]*+"));
        b.rule((GrammarRuleKey)NEXT_NOT_LET_AND_BRACKET).is(b.nextNot((Object)LET, new Object[]{EcmaScriptPunctuator.LBRACKET}));
        b.rule((GrammarRuleKey)NEXT_NOT_LET).is(b.nextNot((Object)LET));
        b.rule((GrammarRuleKey)NEXT_NOT_LCURLY_AND_FUNCTION).is(b.nextNot(b.firstOf((Object)EcmaScriptPunctuator.LCURLYBRACE, (Object)EcmaScriptKeyword.FUNCTION)));
        b.rule((GrammarRuleKey)NEXT_NOT_FUNCTION_AND_CLASS).is(b.nextNot((Object)EcmaScriptKeyword.FUNCTION, new Object[]{EcmaScriptKeyword.CLASS}));
        b.rule((GrammarRuleKey)NEXT_NOT_LCURLY).is(b.nextNot((Object)EcmaScriptPunctuator.LCURLYBRACE));
        b.rule((GrammarRuleKey)NEXT_NOT_ES6_ASSIGNMENT_EXPRESSION).is(b.nextNot(b.regexp("(?:[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]|//[^\\n\\r]*+|<!--[^\\n\\r]*+|/\\*[^\\n\\r]*?\\*/)*+"), new Object[]{"=>"}));
        EcmaScriptGrammar.punctuators(b);
        EcmaScriptGrammar.keywords(b);
    }

    private static void punctuators(LexerlessGrammarBuilder b) {
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LCURLYBRACE, "{");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.RCURLYBRACE, "}");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LPARENTHESIS, "(");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.RPARENTHESIS, ")");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LBRACKET, "[");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.RBRACKET, "]");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DOUBLEARROW, "=>");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DOT, ".");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.ELLIPSIS, "...");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SEMI, ";");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.COMMA, ",");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LT, "<", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.GT, ">", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LE, "<=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.GE, ">=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.EQUAL, "==", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.NOTEQUAL, "!=", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.EQUAL2, "===");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.NOTEQUAL2, "!==");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.PLUS, "+", b.nextNot(b.firstOf((Object)"+", (Object)"=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MINUS, "-", b.nextNot(b.firstOf((Object)"-", (Object)"=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.STAR, "*", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MOD, "%", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DIV, "/", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.INC, "++");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DEC, "--");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SL, "<<", b.nextNot(b.firstOf((Object)"<", (Object)"=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR, ">>", b.nextNot(b.firstOf((Object)">", (Object)"=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR2, ">>>");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.AND, "&", b.nextNot((Object)"&", new Object[]{"="}));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.OR, "|", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.XOR, "^", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.BANG, "!", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.TILDA, "~");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.ANDAND, "&&");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.OROR, "||");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.QUERY, "?");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.COLON, ":");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.EQU, "=", b.nextNot((Object)"="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.PLUS_EQU, "+=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MINUS_EQU, "-=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DIV_EQU, "/=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.STAR_EQU, "*=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MOD_EQU, "%=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SL_EQU, "<<=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR_EQU, ">>=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR_EQU2, ">>>=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.AND_EQU, "&=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.OR_EQU, "|=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.XOR_EQU, "^=");
    }

    private static void keywords(LexerlessGrammarBuilder b) {
        b.rule((GrammarRuleKey)LETTER_OR_DIGIT).is(b.regexp("\\p{javaJavaIdentifierPart}"));
        Object[] rest = new Object[EcmaScriptKeyword.values().length - 2];
        for (int i = 0; i < EcmaScriptKeyword.values().length; ++i) {
            EcmaScriptKeyword tokenType = EcmaScriptKeyword.values()[i];
            b.rule((GrammarRuleKey)tokenType).is((Object)SPACING, new Object[]{tokenType.getValue(), b.nextNot((Object)LETTER_OR_DIGIT)});
            if (i <= 1) continue;
            rest[i - 2] = tokenType.getValue();
        }
        b.rule((GrammarRuleKey)KEYWORD).is(b.firstOf((Object)EcmaScriptKeyword.keywordValues()[0], (Object)EcmaScriptKeyword.keywordValues()[1], rest), new Object[]{b.nextNot((Object)LETTER_OR_DIGIT)});
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value) {
        for (EcmaScriptPunctuator tokenType : EcmaScriptPunctuator.values()) {
            if (!value.equals(tokenType.getValue())) continue;
            b.rule((GrammarRuleKey)tokenType).is((Object)SPACING, new Object[]{value});
            return;
        }
        throw new IllegalStateException(value);
    }

    private static Object word(LexerlessGrammarBuilder b, String value) {
        return b.sequence((Object)SPACING, b.token((TokenType)GenericTokenType.IDENTIFIER, (Object)value), new Object[]{b.nextNot((Object)LETTER_OR_DIGIT)});
    }

    private static Object character(LexerlessGrammarBuilder b, String value) {
        return b.sequence((Object)SPACING, (Object)value);
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value, Object element) {
        for (EcmaScriptPunctuator tokenType : EcmaScriptPunctuator.values()) {
            if (!value.equals(tokenType.getValue())) continue;
            b.rule((GrammarRuleKey)tokenType).is((Object)SPACING, new Object[]{value, element});
            return;
        }
        throw new IllegalStateException(value);
    }

    private EcmaScriptGrammar() {
        String name = this.name();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '_' && i + 1 < name.length()) {
                sb.append(name.charAt(++i));
                continue;
            }
            sb.append(Character.toLowerCase(name.charAt(i)));
        }
        this.internalName = sb.toString();
    }

    public String toString() {
        return this.internalName;
    }
}

