/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.lcov;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.sonar.api.measures.CoverageMeasuresBuilder;
import org.sonar.api.utils.SonarException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LCOVParser {
    private static final String SF = "SF:";
    private static final String DA = "DA:";
    private static final String BRDA = "BRDA:";
    private static final String END_RECORD = "end_of_record";

    public Map<String, CoverageMeasuresBuilder> parseFile(File file) {
        List lines;
        try {
            lines = FileUtils.readLines((File)file);
        }
        catch (IOException e) {
            throw new SonarException("Could not read content from file: " + file, (Throwable)e);
        }
        return this.parse(lines);
    }

    public Map<String, CoverageMeasuresBuilder> parse(List<String> lines) {
        HashMap coveredFiles = Maps.newHashMap();
        HashMap branches = Maps.newHashMap();
        String filePath = null;
        CoverageMeasuresBuilder fileCoverage = CoverageMeasuresBuilder.create();
        for (String line : lines) {
            if (line.startsWith(SF)) {
                fileCoverage = CoverageMeasuresBuilder.create();
                filePath = line.substring(SF.length());
                continue;
            }
            if (line.startsWith(DA)) {
                String execution = line.substring(DA.length());
                String executionCount = execution.substring(execution.indexOf(44) + 1);
                String lineNumber = execution.substring(0, execution.indexOf(44));
                fileCoverage.setHits(Integer.valueOf(lineNumber).intValue(), Integer.valueOf(executionCount).intValue());
                continue;
            }
            if (line.startsWith(BRDA)) {
                String[] tokens = line.substring(BRDA.length()).trim().split(",");
                String lineNumber = tokens[0];
                boolean taken = "1".equals(tokens[3]);
                BranchData branchData = (BranchData)branches.get(lineNumber);
                if (branchData == null) {
                    branchData = new BranchData();
                    branches.put(lineNumber, branchData);
                }
                ++branchData.branches;
                if (!taken) continue;
                ++branchData.visitedBranches;
                continue;
            }
            if (!END_RECORD.equals(line.trim())) continue;
            for (Map.Entry entry : branches.entrySet()) {
                fileCoverage.setConditions(Integer.valueOf((String)entry.getKey()).intValue(), ((BranchData)entry.getValue()).branches, ((BranchData)entry.getValue()).visitedBranches);
            }
            branches.clear();
            coveredFiles.put(filePath, fileCoverage);
        }
        return coveredFiles;
    }

    private static class BranchData {
        int branches;
        int visitedBranches;

        private BranchData() {
        }
    }
}

