/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.lcov;

import java.io.File;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.CoverageMeasuresBuilder;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.PropertiesBuilder;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.javascript.core.JavaScript;
import org.sonar.plugins.javascript.lcov.LCOVParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LCOVSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(LCOVSensor.class);
    private JavaScript javascript;

    public LCOVSensor(JavaScript javascript) {
        this.javascript = javascript;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return "js".equals(project.getLanguageKey()) && StringUtils.isNotBlank((String)this.javascript.getSettings().getString("sonar.javascript.lcov.reportPath"));
    }

    public void analyse(Project project, SensorContext context) {
        File lcovFile = project.getFileSystem().resolvePath(this.javascript.getSettings().getString("sonar.javascript.lcov.reportPath"));
        if (lcovFile.isFile()) {
            LCOVParser parser = new LCOVParser();
            LOG.info("Analysing {}", (Object)lcovFile);
            Map<String, CoverageMeasuresBuilder> coveredFiles = parser.parseFile(lcovFile);
            this.analyseCoveredFiles(project, context, coveredFiles);
        }
    }

    protected void analyseCoveredFiles(Project project, SensorContext context, Map<String, CoverageMeasuresBuilder> coveredFiles) {
        for (InputFile inputFile : project.getFileSystem().mainFiles(new String[]{"js"})) {
            try {
                CoverageMeasuresBuilder fileCoverage = this.getFileCoverage(inputFile, coveredFiles);
                org.sonar.api.resources.File resource = org.sonar.api.resources.File.fromIOFile((File)inputFile.getFile(), (Project)project);
                PropertiesBuilder lineHitsData = new PropertiesBuilder(CoreMetrics.COVERAGE_LINE_HITS_DATA);
                if (fileCoverage != null) {
                    for (Measure measure : fileCoverage.createMeasures()) {
                        context.saveMeasure((Resource)resource, measure);
                    }
                    continue;
                }
                for (int x = 1; x < context.getMeasure((Resource)resource, CoreMetrics.LINES).getIntValue(); ++x) {
                    lineHitsData.add((Object)x, (Object)0);
                }
                Measure ncloc = context.getMeasure((Resource)resource, CoreMetrics.NCLOC);
                context.saveMeasure((Resource)resource, lineHitsData.build());
                context.saveMeasure((Resource)resource, CoreMetrics.LINES_TO_COVER, ncloc.getValue());
                context.saveMeasure((Resource)resource, CoreMetrics.UNCOVERED_LINES, ncloc.getValue());
            }
            catch (Exception e) {
                LOG.error("Problem while calculating coverage for " + inputFile.getFileBaseDir() + inputFile.getRelativePath(), (Throwable)e);
            }
        }
    }

    protected CoverageMeasuresBuilder getFileCoverage(InputFile input, Map<String, CoverageMeasuresBuilder> coveredFiles) {
        CoverageMeasuresBuilder result = coveredFiles.get(input.getRelativePath());
        if (result == null) {
            result = coveredFiles.get(input.getFile().getAbsolutePath());
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

