/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.jstest;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.File;
import org.sonar.api.resources.Project;
import org.sonar.plugins.javascript.core.JavaScript;
import org.sonar.plugins.javascript.jstestdriver.JsTestDriverSensor;

public class JsTestSensor
extends JsTestDriverSensor {
    public JsTestSensor(JavaScript javascript) {
        super(javascript);
    }

    @Override
    public boolean shouldExecuteOnProject(Project project) {
        return this.javascript.equals(project.getLanguage()) && StringUtils.isNotBlank((String)this.javascript.getSettings().getString("sonar.javascript.jstest.reportsPath"));
    }

    @Override
    public void analyse(Project project, SensorContext context) {
        String jsTestDriverFolder = this.javascript.getSettings().getString("sonar.javascript.jstest.reportsPath");
        this.collect(project, context, project.getFileSystem().resolvePath(jsTestDriverFolder));
    }

    @Override
    protected File getUnitTestFileResource(String classKey) {
        return new File(classKey);
    }

    @Override
    protected String getUnitTestFileName(String className) {
        return className;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }
}

