/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.lcov;

import java.io.File;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.config.Settings;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.CoverageMeasuresBuilder;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.PropertiesBuilder;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.FileQuery;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.plugins.javascript.lcov.LCOVParser;

public class CoverageSensor
implements Sensor {
    private static final Logger LOG = LoggerFactory.getLogger(CoverageSensor.class);
    private final ModuleFileSystem moduleFileSystem;
    private final Settings settings;

    public CoverageSensor(ModuleFileSystem moduleFileSystem, Settings settings) {
        this.moduleFileSystem = moduleFileSystem;
        this.settings = settings;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return !this.moduleFileSystem.files(FileQuery.onSource().onLanguage(new String[]{"js"})).isEmpty();
    }

    public void analyse(Project project, SensorContext context) {
        if (this.isLCOVReportProvided()) {
            this.saveMeasureFromLCOVFile(project, context);
        } else if (this.isForceZeroCoverageActivated()) {
            this.saveZeroValueForAllFiles(project, context);
        }
    }

    protected void saveZeroValueForAllFiles(Project project, SensorContext context) {
        for (File file : this.moduleFileSystem.files(FileQuery.onSource().onLanguage(new String[]{"js"}))) {
            this.saveZeroValueForResource(org.sonar.api.resources.File.fromIOFile((File)file, (Project)project), context);
        }
    }

    protected void saveMeasureFromLCOVFile(Project project, SensorContext context) {
        String providedPath = this.settings.getString("sonar.javascript.lcov.reportPath");
        File lcovFile = CoverageSensor.getIOFile(this.moduleFileSystem.baseDir(), providedPath);
        if (!lcovFile.isFile()) {
            LOG.warn("No coverage information will be saved because LCOV file cannot be analysed. Provided LCOV file path: {}", (Object)providedPath);
            return;
        }
        LOG.info("Analysing {}", (Object)lcovFile);
        LCOVParser parser = new LCOVParser(this.moduleFileSystem.baseDir());
        Map<String, CoverageMeasuresBuilder> coveredFiles = parser.parseFile(lcovFile);
        for (File file : this.moduleFileSystem.files(FileQuery.onSource().onLanguage(new String[]{"js"}))) {
            try {
                CoverageMeasuresBuilder fileCoverage = coveredFiles.get(file.getAbsolutePath());
                org.sonar.api.resources.File resource = org.sonar.api.resources.File.fromIOFile((File)file, (Project)project);
                if (fileCoverage != null) {
                    for (Measure measure : fileCoverage.createMeasures()) {
                        context.saveMeasure((Resource)resource, measure);
                    }
                    continue;
                }
                this.saveZeroValueForResource(resource, context);
            }
            catch (Exception e) {
                LOG.error("Problem while calculating coverage for " + file.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    private void saveZeroValueForResource(org.sonar.api.resources.File resource, SensorContext context) {
        PropertiesBuilder lineHitsData = new PropertiesBuilder(CoreMetrics.COVERAGE_LINE_HITS_DATA);
        for (int x = 1; x < context.getMeasure((Resource)resource, CoreMetrics.LINES).getIntValue(); ++x) {
            lineHitsData.add((Object)x, (Object)0);
        }
        Measure ncloc = context.getMeasure((Resource)resource, CoreMetrics.NCLOC);
        context.saveMeasure((Resource)resource, lineHitsData.build());
        context.saveMeasure((Resource)resource, CoreMetrics.LINES_TO_COVER, ncloc.getValue());
        context.saveMeasure((Resource)resource, CoreMetrics.UNCOVERED_LINES, ncloc.getValue());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    private boolean isForceZeroCoverageActivated() {
        return this.settings.getBoolean("sonar.javascript.forceZeroCoverage");
    }

    private boolean isLCOVReportProvided() {
        return StringUtils.isNotBlank((String)this.settings.getString("sonar.javascript.lcov.reportPath"));
    }

    public static File getIOFile(File baseDir, String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(baseDir, path);
        }
        return file;
    }
}

