/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.unittest.surefireparser;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.StaxParser;
import org.sonar.plugins.javascript.unittest.surefireparser.SurefireStaxHandler;
import org.sonar.plugins.javascript.unittest.surefireparser.UnitTestClassReport;
import org.sonar.plugins.javascript.unittest.surefireparser.UnitTestIndex;

public abstract class AbstractSurefireParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSurefireParser.class);

    public void collect(SensorContext context, File reportsDir) {
        File[] xmlFiles = this.getReports(reportsDir);
        if (xmlFiles.length > 0) {
            this.parseFiles(context, xmlFiles);
        } else {
            LOGGER.warn("No Unit Test information will be saved, because no Unit Test report has been found in the given directory: {}" + reportsDir.getAbsolutePath());
        }
    }

    private File[] getReports(File dir) {
        if (dir == null) {
            return new File[0];
        }
        if (!dir.isDirectory()) {
            LOGGER.warn("Reports path not found: " + dir.getAbsolutePath());
            return new File[0];
        }
        File[] unitTestResultFiles = this.findXMLFilesStartingWith(dir, "TEST-");
        if (unitTestResultFiles.length == 0) {
            unitTestResultFiles = this.findXMLFilesStartingWith(dir, "TESTS-");
        }
        return unitTestResultFiles;
    }

    private File[] findXMLFilesStartingWith(File dir, final String fileNameStart) {
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(fileNameStart) && name.endsWith(".xml");
            }
        });
    }

    private void parseFiles(SensorContext context, File[] reports) {
        UnitTestIndex index = new UnitTestIndex();
        this.parseFiles(reports, index);
        this.sanitize(index);
        this.save(index, context);
    }

    private void parseFiles(File[] reports, UnitTestIndex index) {
        SurefireStaxHandler staxParser = new SurefireStaxHandler(index);
        StaxParser parser = new StaxParser((StaxParser.XmlStreamHandler)staxParser, false);
        for (File report : reports) {
            try {
                parser.parse(report);
            }
            catch (XMLStreamException e) {
                throw new SonarException("Fail to parse the Surefire report: " + report, (Throwable)e);
            }
        }
    }

    private void sanitize(UnitTestIndex index) {
        for (String classname : index.getClassnames()) {
            if (!StringUtils.contains((String)classname, (String)"$")) continue;
            String parentClassName = StringUtils.substringBefore((String)classname, (String)"$");
            index.merge(classname, parentClassName);
        }
    }

    private void save(UnitTestIndex index, SensorContext context) {
        for (Map.Entry<String, UnitTestClassReport> entry : index.getIndexByClassname().entrySet()) {
            UnitTestClassReport report = entry.getValue();
            if (report.getTests() <= 0L) continue;
            Resource resource = this.getUnitTestResource(entry.getKey());
            this.save(entry.getValue(), resource, context);
        }
    }

    private void save(UnitTestClassReport report, Resource resource, SensorContext context) {
        double testsCount = report.getTests() - report.getSkipped();
        this.saveMeasure(context, resource, CoreMetrics.SKIPPED_TESTS, report.getSkipped());
        this.saveMeasure(context, resource, CoreMetrics.TESTS, testsCount);
        this.saveMeasure(context, resource, CoreMetrics.TEST_ERRORS, report.getErrors());
        this.saveMeasure(context, resource, CoreMetrics.TEST_FAILURES, report.getFailures());
        this.saveMeasure(context, resource, CoreMetrics.TEST_EXECUTION_TIME, report.getDurationMilliseconds());
        double passedTests = testsCount - (double)report.getErrors() - (double)report.getFailures();
        if (testsCount > 0.0) {
            double percentage = passedTests * 100.0 / testsCount;
            this.saveMeasure(context, resource, CoreMetrics.TEST_SUCCESS_DENSITY, ParsingUtils.scaleValue((double)percentage));
        }
        this.saveResults(context, resource, report);
    }

    private void saveMeasure(SensorContext context, Resource resource, Metric metric, double value) {
        if (!Double.isNaN(value)) {
            context.saveMeasure(resource, metric, Double.valueOf(value));
        }
    }

    protected void saveResults(SensorContext context, Resource resource, UnitTestClassReport report) {
        context.saveMeasure(resource, new Measure(CoreMetrics.TEST_DATA, report.toXml()));
    }

    protected abstract Resource getUnitTestResource(String var1);
}

